/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.compiler.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import spec.benchmarks.compiler.Compiler;
import spec.benchmarks.compiler.MainBase;
import spec.benchmarks.compiler.Util;
import spec.harness.StopBenchmarkException;
import spec.harness.results.BenchmarkResult;

public class Main
extends MainBase {
    public Main(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId, 1);
        String[] args = new String[]{"-nowarn", "-proc:none", "@" + srcsFile.getPath()};
        this.compiler = new Compiler(args);
    }

    public static void setupBenchmark() {
        MainBase.preSetupBenchmark(Main.class);
        srcsFile = Main.getSrcFile(resDir, tmpDir);
        new Main(new BenchmarkResult(), 1).harnessMain(true);
    }

    public static File getSrcFile(File resDir, File tmpDir) {
        File srcsFile = Util.getSrcFile(tmpDir);
        File srcDir = Util.getSrcDir(resDir, "compiler.compiler");
        File compilerZip = Util.getZipFile(srcDir);
        try {
            ArrayList<String> srcs = new ArrayList<String>();
            FileWriter fw = new FileWriter(srcsFile);
            Util.unzip(compilerZip.getPath(), tmpDir.getPath(), srcs);
            for (String src : srcs) {
                if (!src.endsWith(".java") || !src.contains("/src/share/classes/")) continue;
                if (src.endsWith("version-template.java")) {
                    String version = src.replace("-template", "");
                    File templateFile = new File(src);
                    File versionFile = new File(version);
                    templateFile.renameTo(versionFile);
                    src = version;
                }
                fw.write(src);
                fw.write(Util.linesep());
            }
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new StopBenchmarkException("ERROR: could not create: " + srcsFile.getPath());
        }
        return srcsFile;
    }

    public static void main(String[] args) throws Exception {
        Main.runSimple(Main.class, args);
    }
}

