/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.compiler;

import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacFileManager;
import com.sun.tools.javac.util.ListBuffer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import spec.benchmarks.compiler.Compiler;
import spec.benchmarks.compiler.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecFileManager
extends JavacFileManager {
    static HashMap<String, Iterable<JavaFileObject>> map = new HashMap();
    static HashMap<JavaFileManager.Location, Iterable<? extends File>> locationMap = new HashMap();
    static HashMap<File, InputFileObject> inputFiles = new HashMap();
    private long crc = 1L;

    public static void preRegister(final Context context, final Compiler compiler) {
        context.put(JavaFileManager.class, new Context.Factory<JavaFileManager>(){

            public JavaFileManager make() {
                SpecFileManager fileManager;
                compiler.fileManager = fileManager = new SpecFileManager(context, true, null);
                return fileManager;
            }
        });
    }

    public static void reset() {
        map = new HashMap();
        locationMap = new HashMap();
        inputFiles = new HashMap();
    }

    public SpecFileManager(Context context, boolean register, Charset charset) {
        super(context, register, charset);
    }

    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        String key = SpecFileManager.generateKey(location, packageName, kinds, recurse);
        if (map.containsKey(key)) {
            return map.get(key);
        }
        Iterable superResults = super.list(location, packageName, kinds, recurse);
        ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        for (JavaFileObject obj : superResults) {
            results.append(new CachedFileObject(obj));
        }
        map.put(key, results.toList());
        return results;
    }

    public static String generateKey(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) {
        String result = location.getName() + "," + location.isOutputLocation() + ";" + packageName + ";";
        for (JavaFileObject.Kind kind : kinds) {
            result = result + kind.extension;
        }
        result = result + ";" + recurse;
        return result;
    }

    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof CachedFileObject) {
            return this.inferBinaryName2(location, (CachedFileObject)file);
        }
        return super.inferBinaryName(location, file);
    }

    public String inferBinaryName2(JavaFileManager.Location location, CachedFileObject file) {
        file.getClass();
        location.getClass();
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        if ("RegularFileObject".equals(file.history)) {
            String rPath = file.path;
            for (File file2 : path) {
                String dPath = file2.getPath();
                if (!dPath.endsWith(File.separator)) {
                    dPath = dPath + File.separator;
                }
                if (!rPath.regionMatches(true, 0, dPath, 0, dPath.length()) || !new File(rPath.substring(0, dPath.length())).equals(new File(dPath))) continue;
                String relativeName = rPath.substring(dPath.length());
                return SpecFileManager.removeExtension(relativeName).replace(File.separatorChar, '.');
            }
        } else {
            if ("ZipFileObject".equals(file.history)) {
                String entryName = file.path;
                return SpecFileManager.removeExtension(entryName).replace('/', '.');
            }
            if ("ZipFileIndexFileObject".equals(file.history)) {
                String entryName = file.path;
                return SpecFileManager.removeExtension(entryName).replace(File.separatorChar, '.');
            }
            throw new IllegalArgumentException(file.getClass().getName());
        }
        return null;
    }

    private static String removeExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        return lastDot == -1 ? fileName : fileName.substring(0, lastDot);
    }

    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        if (locationMap.containsKey(location)) {
            return locationMap.get(location);
        }
        Iterable result = super.getLocation(location);
        locationMap.put(location, result);
        return result;
    }

    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        ArrayList<InputFileObject> result = files instanceof Collection ? new ArrayList(((Collection)files).size()) : new ArrayList<InputFileObject>();
        for (File file : files) {
            if (inputFiles.containsKey(file)) {
                result.add(inputFiles.get(file));
                continue;
            }
            InputFileObject obj = new InputFileObject(file.getName(), file);
            inputFiles.put(file, obj);
            result.add(obj);
        }
        return result;
    }

    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        int index = className.lastIndexOf(".");
        String name = className.substring(index + 1, className.length()) + ".class";
        return new OutputFileObject(name);
    }

    public long getChecksum() {
        return this.crc;
    }

    public class CachedFileObject
    extends BaseFileObject {
        JavaFileObject.Kind kind;
        String name;
        NestingKind nestingKind;
        String history;
        String path;
        byte[] b;

        CachedFileObject(JavaFileObject jfo) {
            this.kind = jfo.getKind();
            this.name = jfo.getName();
            this.nestingKind = jfo.getNestingKind();
            if (jfo instanceof JavacFileManager.RegularFileObject) {
                this.history = "RegularFileObject";
                this.path = ((JavacFileManager.RegularFileObject)jfo).getPath();
            } else if (jfo instanceof JavacFileManager.ZipFileObject) {
                this.history = "ZipFileObject";
                this.path = ((JavacFileManager.ZipFileObject)jfo).getZipEntryName();
            } else if (jfo instanceof JavacFileManager.ZipFileIndexFileObject) {
                this.history = "ZipFileIndexFileObject";
                this.path = ((JavacFileManager.ZipFileIndexFileObject)jfo).getZipEntryName();
            }
            try {
                InputStream is = jfo.openInputStream();
                this.b = Util.getBytes(is);
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public JavaFileObject.Kind getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public NestingKind getNestingKind() {
            return this.nestingKind;
        }

        public InputStream openInputStream() throws IOException {
            return new ByteArrayInputStream(this.b);
        }
    }

    public class OutputFileObject
    extends BaseFileObject {
        String name;

        public OutputFileObject(String name) {
            this.name = name;
        }

        public OutputStream openOutputStream() throws IOException {
            return new OutputStream(){

                public void write(int b) throws IOException {
                    SpecFileManager.this.crc = SpecFileManager.this.crc * 33L + (long)b;
                }

                public void write(byte[] b) throws IOException {
                    for (int i = 0; i < b.length; ++i) {
                        SpecFileManager.this.crc = SpecFileManager.this.crc * 33L + (long)b[i];
                    }
                }

                public void write(byte[] b, int offset, int len) throws IOException {
                    for (int i = offset; i < offset + len; ++i) {
                        SpecFileManager.this.crc = SpecFileManager.this.crc * 33L + (long)b[i];
                    }
                }
            };
        }
    }

    public class InputFileObject
    extends JavacFileManager.RegularFileObject {
        CharBuffer buffer;

        public InputFileObject(String name, File f) {
            super((JavacFileManager)SpecFileManager.this, name, f);
            try {
                byte[] b = Util.getBytes(f);
                ByteBuffer buf = ByteBuffer.wrap(b);
                CharsetDecoder decoder = Util.CHARSET.newDecoder().onMalformedInput(Util.ACTION).onUnmappableCharacter(Util.ACTION);
                this.buffer = decoder.decode(buf).asReadOnlyBuffer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public InputStream openInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.buffer;
        }
    }

    public class BaseFileObject
    implements JavaFileObject {
        public boolean delete() {
            throw new UnsupportedOperationException("delete()");
        }

        public Modifier getAccessLevel() {
            throw new UnsupportedOperationException("getAccessLevel()");
        }

        public CharSequence getCharContent(boolean arg0) throws IOException {
            throw new UnsupportedOperationException("getCharContent(boolean)");
        }

        public JavaFileObject.Kind getKind() {
            throw new UnsupportedOperationException("getKind()");
        }

        public long getLastModified() {
            throw new UnsupportedOperationException("getLastModified()");
        }

        public String getName() {
            throw new UnsupportedOperationException("getName()");
        }

        public NestingKind getNestingKind() {
            throw new UnsupportedOperationException("getNestingKind()");
        }

        public boolean isNameCompatible(String arg0, JavaFileObject.Kind arg1) {
            throw new UnsupportedOperationException("isNameCompatible(String, Kind)");
        }

        public InputStream openInputStream() throws IOException {
            throw new UnsupportedOperationException("openInputStream");
        }

        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException("openOutputStream()");
        }

        public Reader openReader(boolean arg0) throws IOException {
            throw new UnsupportedOperationException("openReader(boolean)");
        }

        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException("openWriter()");
        }

        public URI toUri() {
            throw new UnsupportedOperationException("toURI");
        }
    }
}

