/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.compiler;

import java.io.File;
import spec.benchmarks.compiler.Compiler;
import spec.benchmarks.compiler.SpecFileManager;
import spec.benchmarks.compiler.Util;
import spec.harness.Context;
import spec.harness.SpecJVMBenchmarkBase;
import spec.harness.results.BenchmarkResult;

public class MainBase
extends SpecJVMBenchmarkBase {
    protected static File resDir = null;
    protected static File tmpDir = null;
    protected static File srcsFile = null;
    protected Compiler compiler;
    protected int loops;

    public MainBase(BenchmarkResult bmResult, int threadId, int compiles) {
        super(bmResult, threadId);
        this.loops = compiles;
    }

    public static String testType() {
        return "multi";
    }

    public static void preSetupBenchmark(Class cl) {
        SpecFileManager.reset();
        resDir = new File(Context.getResourceDirFor(cl));
        tmpDir = Util.getTmpDir(resDir, false);
        if (tmpDir != null) {
            Util.recursiveRemoveDir(tmpDir.getParentFile());
        }
        tmpDir = Util.getTmpDir(resDir, true);
    }

    public static void tearDownBenchmark() {
        Util.recursiveRemoveDir(tmpDir.getParentFile());
        SpecFileManager.reset();
    }

    public void harnessMain() {
        this.compiler.compile(this.loops);
    }

    public void harnessMain(boolean skipVerify) {
        this.compiler.skipVerify = skipVerify;
        this.compiler.compile(this.loops);
    }
}

