/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.check;

import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;
import spec.benchmarks.check.C1;
import spec.benchmarks.check.C2;
import spec.benchmarks.check.C2intf;
import spec.benchmarks.check.C3;
import spec.benchmarks.check.C3intf;
import spec.benchmarks.check.SideIntf;
import spec.benchmarks.check.StringAndInt;
import spec.benchmarks.check.subClass;
import spec.benchmarks.check.superClass;
import spec.benchmarks.check.syncTest;
import spec.harness.Context;

class PepTest {
    public int fisk;
    public boolean gotError = false;
    static subClass[][] staticSubArray = new subClass[][]{{null, null}, {null, null}};
    static int[][] staticIntArray = new int[][]{{1, 2, 3}, {4, 5, 6}};

    PepTest() {
    }

    String testDiv() {
        Context.getOut().print("testDiv:    ");
        int b = 7;
        int a = 7;
        if (1 != a / b) {
            return "failed 1";
        }
        if (-1 != (a = -a) / b) {
            return "failed 2";
        }
        a = 600000000;
        b = 600000000;
        if (1 != a / b) {
            return "failed 1.1";
        }
        if (-1 != (a = -a) / b) {
            return "failed 2.1";
        }
        long c = 8L;
        long d = 8L;
        if (1L != c / d) {
            return "failed 3";
        }
        if (-1L != (c = -c) / d) {
            return "failed 4";
        }
        c = 600000000L;
        d = 600000000L;
        if (1L != c / d) {
            return "failed 3.1";
        }
        if (-1L != (c = -c) / d) {
            return "failed 4.1";
        }
        b = 0;
        try {
            a /= b;
            return "failed 5";
        }
        catch (Exception x) {
            d = 0L;
            try {
                c /= d;
                return "failed 6";
            }
            catch (Exception x2) {
                try {
                    c %= d;
                    return "failed 6.1";
                }
                catch (Exception x3) {
                    double f = 7.0;
                    double e = 7.0;
                    if (1.0 != e / f) {
                        return "failed 7";
                    }
                    if (-1.0 != (e = -e) / f) {
                        return "failed 8";
                    }
                    f = 0.0;
                    try {
                        e /= f;
                    }
                    catch (Exception x4) {
                        return "failed 9";
                    }
                    try {
                        e %= f;
                        e = 5.6 % f;
                    }
                    catch (Exception x5) {
                        return "failed 9";
                    }
                    return null;
                }
            }
        }
    }

    String testIf() {
        int a;
        Context.getOut().print("testIf:     ");
        int b = a = 3;
        if (b * b != 9) {
            return "branched the wrong way";
        }
        b = 1;
        if (b != 1) {
            return "didn't execute any of the branches";
        }
        a = 0;
        b = 0;
        int c = 0;
        c = a == 0 ? (b == 0 ? 1 : 2) : (b == 0 ? 3 : 4);
        if (c != 1) {
            return "nested if failed in true/true case";
        }
        a = 0;
        b = 1;
        c = 0;
        c = a == 0 ? (b == 0 ? 1 : 2) : (b == 0 ? 3 : 4);
        if (c != 2) {
            return "nested if failed in true/false case";
        }
        a = 1;
        b = 0;
        c = 0;
        c = a == 0 ? (b == 0 ? 1 : 2) : (b == 0 ? 3 : 4);
        if (c != 3) {
            return "nested if failed in false/true case";
        }
        a = 1;
        b = 1;
        c = 0;
        c = a == 0 ? (b == 0 ? 1 : 2) : (b == 0 ? 3 : 4);
        if (c != 4) {
            return "nested if failed in false/false case";
        }
        return null;
    }

    int shiftAnd(int v, int s) {
        return v >>> s & 0xFF;
    }

    String testBitOps() {
        Context.getOut().print("testBitOps: ");
        int v = -889275714;
        if (this.shiftAnd(v, 24) != 202) {
            return "bad shift-and 1";
        }
        if (this.shiftAnd(v, 16) != 254) {
            return "bad shift-and 2";
        }
        if (this.shiftAnd(v, 8) != 186) {
            return "bad shift-and 3";
        }
        if (this.shiftAnd(v, 0) != 190) {
            return "bad shift-and 4";
        }
        return null;
    }

    String testFor() {
        int s = 0;
        Context.getOut().print("testFor:    ");
        for (int a = 0; a < 100; ++a) {
            for (int b = a; b >= 0; b -= 2) {
                s = a + s + b;
            }
        }
        if (s != 252450) {
            return "wrong check sum";
        }
        return null;
    }

    String testTableSwitch() {
        int r;
        Context.getOut().print("testTableSwitch:  ");
        int s = 2;
        switch (s *= 3) {
            case 0: 
            case 4: {
                r = 0;
                break;
            }
            case 1: 
            case 2: {
                r = 1;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                r = 3;
                break;
            }
            default: {
                r = -1;
            }
        }
        if (r != 3) {
            return "took wrong case branch";
        }
        switch (s += 100) {
            case 0: 
            case 4: {
                r = 0;
                break;
            }
            case 1: 
            case 2: {
                r = 1;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                r = 3;
                break;
            }
            default: {
                r = -1;
            }
        }
        if (r != -1) {
            return "failed to take default branch";
        }
        return null;
    }

    String testLookupSwitch() {
        int r;
        Context.getOut().print("testLookupSwitch: ");
        int s = 2;
        switch (s *= 3000) {
            case 0: 
            case 4000: {
                r = 0;
                break;
            }
            case 1000: 
            case 2000: {
                r = 1;
                break;
            }
            case 3000: 
            case 5000: 
            case 6000: {
                r = 3;
                break;
            }
            default: {
                r = -1;
            }
        }
        if (r != 3) {
            return "took wrong case branch";
        }
        switch (s += 999999999) {
            case 0: 
            case 4000: {
                r = 0;
                break;
            }
            case 1000: 
            case 2000: {
                r = 1;
                break;
            }
            case 3000: 
            case 5000: 
            case 6000: {
                r = 3;
                break;
            }
            default: {
                r = -1;
            }
        }
        if (r != -1) {
            return "failed to take default branch";
        }
        return null;
    }

    String testHiddenField() {
        subClass f2;
        Context.getOut().print("testHiddenField:  ");
        subClass f1 = f2 = new subClass();
        if (((superClass)f1).val != 1) {
            return "direct access to field defined by superclass failed";
        }
        if (f2.val != 2) {
            return "direct access to field defined by subclass failed";
        }
        if (((superClass)f1).getVal() != 2) {
            return "access through method to field defined by superclass failed";
        }
        if (f2.getVal() != 2) {
            return "access through method to field defined by subclass failed";
        }
        return null;
    }

    void printTime() {
        Date now = new Date();
        Context.getOut().print("Time now is ");
        Context.getOut().print(now.toString());
        Context.getOut().print(",   ms: ");
        Context.getOut().println(System.currentTimeMillis());
    }

    String checkInst(superClass x, boolean r1, boolean r2, boolean r3, int c) {
        return this.checkInst2(x, r1, x instanceof superClass, "superClass") + this.checkInst2(x, r2, x instanceof subClass, "subClass") + this.checkInst2(x, r3, x instanceof Cloneable, "Cloneable");
    }

    String checkInst2(superClass x, boolean expected, boolean got, String cn) {
        if (expected == got) {
            return "";
        }
        return "Failed: 'a " + x.getClass().getName() + "' instanceof " + cn + " (returned: " + got + ", should be: " + expected + ")\n";
    }

    String checkInstanceOf() {
        Context.getOut().print("checkInstanceOf: ");
        if (!(new superClass[2] instanceof superClass[])) {
            return "failed: new superClass[2]) instanceof superClass[]";
        }
        if (!(new subClass[2] instanceof superClass[])) {
            return "failed: new subClass[2]) instanceof superClass[]";
        }
        if (new superClass[2] instanceof subClass[]) {
            return "failed: new superClass[2]) instanceof subClass[]";
        }
        if (new Object[2] instanceof subClass[]) {
            return "failed: new Object[2]) instanceof subClass[]";
        }
        if (!(new subClass[2] instanceof Cloneable[])) {
            return "failed: new subClass[2]) instanceof Cloneable[]";
        }
        return this.checkInst(null, false, false, false, 1) + this.checkInst(new superClass(), true, false, true, 2) + this.checkInst(new subClass(), true, true, true, 3);
    }

    String checkInterfaceInstanceOf() {
        Context.getOut().print("checkInterfaceInstanceOf: ");
        C1 c1 = new C1();
        C2 c2 = new C2();
        C3 c3 = new C3();
        if (!(c1 instanceof C1)) {
            return "checkInterfaceInstanceOf: error-1";
        }
        if (c1 instanceof C2) {
            return "checkInterfaceInstanceOf: error-2";
        }
        if (c1 instanceof C3) {
            return "checkInterfaceInstanceOf: error-3";
        }
        if (!(c2 instanceof C1)) {
            return "checkInterfaceInstanceOf: error-4";
        }
        if (!(c2 instanceof C2)) {
            return "checkInterfaceInstanceOf: error-5";
        }
        if (c2 instanceof C3) {
            return "checkInterfaceInstanceOf: error-6";
        }
        if (!(c3 instanceof C1)) {
            return "checkInterfaceInstanceOf: error-7";
        }
        if (!(c3 instanceof C2)) {
            return "checkInterfaceInstanceOf: error-8";
        }
        if (!(c3 instanceof C3)) {
            return "checkInterfaceInstanceOf: error-9";
        }
        if (c1 instanceof C2intf) {
            return "checkInterfaceInstanceOf: error-10";
        }
        if (c1 instanceof C3intf) {
            return "checkInterfaceInstanceOf: error-11";
        }
        if (c1 instanceof SideIntf) {
            return "checkInterfaceInstanceOf: error-12";
        }
        if (!(c2 instanceof C2intf)) {
            return "checkInterfaceInstanceOf: error-13";
        }
        if (c2 instanceof C3intf) {
            return "checkInterfaceInstanceOf: error-14";
        }
        if (c2 instanceof SideIntf) {
            return "checkInterfaceInstanceOf: error-15";
        }
        if (!(c3 instanceof C2intf)) {
            return "checkInterfaceInstanceOf: error-16";
        }
        if (!(c3 instanceof C3intf)) {
            return "checkInterfaceInstanceOf: error-17";
        }
        if (!(c3 instanceof SideIntf)) {
            return "checkInterfaceInstanceOf: error-18";
        }
        return null;
    }

    String testExc1() {
        block6: {
            Context.getOut().print("testExc1(simple throw/catch):  ");
            int x = 0;
            try {
                x = x == 0 ? 1 : -1;
                if (x != 47) {
                    throw new ArithmeticException("fisk");
                }
                x = -1;
            }
            catch (ArithmeticException exc) {
                x = x == 1 ? 2 : -1;
            }
            if (x != 2) {
                return "failed-1";
            }
            int[] arr = new int[10];
            try {
                arr[11] = 11;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (e.getClass().getName().equals("java.lang.ArrayIndexOutOfBoundsException")) break block6;
                return "failed-2: " + e.getClass().getName();
            }
        }
        return null;
    }

    String testExc2() {
        Context.getOut().print("testExc2(skip catch clauses):  ");
        int x = 0;
        try {
            x = x == 0 ? 1 : -1;
            if (x != 47) {
                throw new RuntimeException("fisk");
            }
            x = -1;
        }
        catch (ArithmeticException exc) {
            x = -1;
        }
        catch (AbstractMethodError exc) {
            x = -1;
        }
        catch (RuntimeException exc) {
            x = x == 1 ? 2 : -1;
        }
        if (x == 2) {
            return null;
        }
        return "failed";
    }

    String testExc3() {
        Context.getOut().print("testExc3(catch in inner):      ");
        int x = 0;
        try {
            x = x == 0 ? 1 : -1;
            try {
                x = x != 1 ? -1 : 2;
                if (x != 47) {
                    throw new ArithmeticException("fisk");
                }
                return "failed-1";
            }
            catch (ArithmeticException exc) {
                x = x != 2 ? -1 : 3;
            }
        }
        catch (ArithmeticException exc) {
            x = -1;
        }
        if (x == 3) {
            return null;
        }
        return "failed-2";
    }

    String testExc4() {
        Context.getOut().print("testExc4(catch in outer):      ");
        int x = 0;
        try {
            x = x == 0 ? 1 : -1;
            try {
                x = x != 1 ? -1 : 2;
                if (x != 47) {
                    throw new RuntimeException("fisk");
                }
            }
            catch (ArithmeticException exc) {
                x = -1;
            }
        }
        catch (RuntimeException exc) {
            x = x != 2 ? -1 : 3;
        }
        if (x == 3) {
            return null;
        }
        return "failed";
    }

    String testExc5() {
        Context.getOut().print("testExc5(rethrow):             ");
        int x = 0;
        try {
            x = x == 0 ? 1 : -1;
            try {
                x = x != 1 ? -1 : 2;
                if (x != 47) {
                    throw new ArithmeticException("fisk");
                }
            }
            catch (ArithmeticException exc) {
                x = x != 2 ? -1 : 3;
                throw exc;
            }
        }
        catch (ArithmeticException exc) {
            x = x != 3 ? -1 : 4;
        }
        if (x == 4) {
            return null;
        }
        return "failed";
    }

    String testExc6() {
        Context.getOut().print("testExc6(throw accross call):  ");
        int x = 0;
        try {
            x = 1;
            this.throwArithmeticException(1);
            x = 2;
        }
        catch (ArithmeticException exc) {
            x = x != 1 ? -1 : 4;
        }
        if (x == 4) {
            return null;
        }
        return "failed";
    }

    String testExc7() {
        Context.getOut().print("testExc7(throw accr. 2 calls): ");
        int x = 0;
        try {
            x = 1;
            x = this.dontDouble(x);
            x = 2;
        }
        catch (ArithmeticException exc) {
            x = x != 1 ? -1 : 4;
        }
        if (x == 4) {
            return null;
        }
        return "failed";
    }

    String stringHash(String str, int expected11, int expected12) {
        if (str.hashCode() != expected11 && str.hashCode() != expected12) {
            return "unexpected string hash value for '" + str + "': " + str.hashCode() + " (expected: " + expected11 + " or " + expected12 + ")";
        }
        return null;
    }

    String testStringHash() {
        Context.getOut().print("testStringHash:  ");
        String res = this.stringHash("monkey", -817689237, -1068495917);
        if (null != res) {
            return res;
        }
        res = this.stringHash("donkey", -1441784850, -1326158276);
        if (null != res) {
            return res;
        }
        res = this.stringHash("Lavazza", 84343969, 1619816993);
        if (null != res) {
            return res;
        }
        res = this.stringHash("and a longer string with many words 123454876*=+-_%$$@", 47854477, 304406733);
        if (null != res) {
            return res;
        }
        return null;
    }

    String testObjectHash() {
        Context.getOut().print("testObjectHash:  ");
        Hashtable<Integer, Integer> ht = new Hashtable<Integer, Integer>();
        for (int i = 0; i < 1000; ++i) {
            Integer ii = new syncTest().hashCode();
            ht.put(ii, ii);
        }
        if (ht.size() < 700) {
            return "Hash codes not very unique; out of 1000 got only " + ht.size() + " unique";
        }
        return null;
    }

    String loopExitContinueInExceptionHandler() {
        int i;
        Context.getOut().print("loopExitContinueInExceptionHandler: ");
        for (i = 0; i < 10000; ++i) {
            try {
                if (i % 100 == 0) {
                    throw new ArithmeticException("fisk");
                }
                if (i == 9990) break;
                if (i % 2 != 0) continue;
            }
            catch (ArithmeticException e) {
                if (i % 2 == 0) continue;
                return "Should not throw odd exceptions!";
            }
        }
        if (i != 9990) {
            return "Seems that break didn't work";
        }
        return null;
    }

    String testClone() {
        int i;
        Context.getOut().print("testClone:       ");
        int[] v = new int[100];
        for (i = 0; i < v.length; ++i) {
            v[i] = i * i;
        }
        int[] w = (int[])v.clone();
        if (v.length != w.length) {
            return "Clone of int array failed (length)";
        }
        for (i = 0; i < w.length; ++i) {
            if (w[i] == i * i) continue;
            return "Clone of int array failed-" + i;
        }
        Hashtable ht = new Hashtable(31);
        if (ht.clone() == ht) {
            return "Clone failed on hash tables";
        }
        boolean caught = false;
        try {
            ht = null;
            ht.clone();
        }
        catch (NullPointerException gotIt) {
            caught = true;
        }
        if (!caught) {
            return "failed to catch exception from null.clone()";
        }
        StringAndInt s1 = new StringAndInt();
        s1.s = "goat";
        s1.i = 5;
        StringAndInt s2 = (StringAndInt)s1.clone();
        if (s1 == s2) {
            return "clone returned same object";
        }
        if (!s2.s.equals("goat")) {
            return "clone didn't get the goat there";
        }
        if (s2.i != 5) {
            return "clone didn't get the 5 there";
        }
        if (!s1.s.equals("goat")) {
            return "clone messed up receiver: goat";
        }
        if (s1.i != 5) {
            return "clone messed up receiver: 5";
        }
        return null;
    }

    String checkClassNameOf(String exp, Object obj, String expected) {
        if (expected.equals(obj.getClass().getName())) {
            return null;
        }
        return "Error: className(" + exp + ") = " + obj.getClass().getName() + ", should be = " + expected;
    }

    void printInterfaces(Class cl) {
        Context.getOut().print(cl.getName() + ":  ");
        Class<?>[] intf = cl.getInterfaces();
        for (int i = 0; i < intf.length; ++i) {
            Context.getOut().print(intf[i].getName() + " ");
            if (intf[i].isInterface()) continue;
            Context.getOut().println("Error: should have been an interface!");
        }
        if (0 == intf.length) {
            Context.getOut().print("no interfaces");
        }
        Context.getOut().println();
    }

    String testClass() {
        String r = this.checkClassNameOf("double[][]", new double[2][3], "[[D");
        if (r != null) {
            return r;
        }
        r = this.checkClassNameOf("7", 7, "java.lang.Integer");
        if (r != null) {
            return r;
        }
        r = this.checkClassNameOf("horse", this, "PepTest");
        if (r != null) {
            return r;
        }
        r = this.checkClassNameOf("new PepTest[2]", new PepTest[2], "[LPepTest;");
        if (r != null) {
            return r;
        }
        r = this.checkClassNameOf("new PepTest[2][2]", new PepTest[2][2], "[[LPepTest;");
        if (r != null) {
            return r;
        }
        r = this.checkClassNameOf("java.util.Hashtable", new Hashtable(), "java.util.Hashtable");
        if (r != null) {
            return r;
        }
        PepTest[] fisk = new PepTest[2];
        if (fisk.getClass().getInterfaces().length != 0) {
            return "Error: array class should not have interfaces";
        }
        this.printInterfaces(fisk.getClass());
        boolean caught = false;
        try {
            this.printInterfaces(null);
        }
        catch (NullPointerException fff) {
            caught = true;
        }
        if (!caught) {
            return "Error: null pointer exception not caught";
        }
        for (Class<?> cl = new Hashtable().getClass(); cl != null; cl = cl.getSuperclass()) {
            this.printInterfaces(cl);
        }
        return null;
    }

    String testWaitNull() {
        Context.getOut().print("testWaitNull: ");
        try {
            ((Object)null).wait(43L);
        }
        catch (Exception e) {
            if (e.getClass().getName().equals("java.lang.NullPointerException")) {
                return null;
            }
            return "error: " + e;
        }
        return "error: missing exception";
    }

    String testVarAndMethodNameClash() {
        Context.getOut().print("testVarAndMethodNameClash: ");
        superClass s = new superClass();
        int x = s.bothVarAndMethod;
        if (x != 7) {
            return "1: Var has wrong value: " + x;
        }
        x = s.bothVarAndMethod();
        if (x != 8) {
            return "1: Method returned wrong value: " + x;
        }
        s.bothVarAndMethod = 9;
        x = s.bothVarAndMethod;
        if (x != 9) {
            return "2: Var has wrong value: " + x;
        }
        x = s.bothVarAndMethod();
        if (x != 8) {
            return "2: Method returned wrong value: " + x;
        }
        s.bothVarAndMethod(5);
        x = s.bothVarAndMethod;
        if (x != 5) {
            return "3: Var has wrong value: " + x;
        }
        x = s.bothVarAndMethod();
        if (x != 8) {
            return "3: Method returned wrong value: " + x;
        }
        return null;
    }

    void checkAllNull(Object[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            Context.getOut().println("error: should have been null");
        }
    }

    String testObjectArray() {
        Context.getOut().print("testObjectArray: ");
        Object[] a = new subClass[10];
        Object[] b = new superClass[10];
        if (!(a instanceof subClass[])) {
            return "array instanceof-1 failed";
        }
        if (!(a instanceof superClass[])) {
            return "array instanceof-2 failed";
        }
        if (!(a instanceof Object[])) {
            return "array instanceof-3 failed";
        }
        if (b instanceof subClass[]) {
            return "array instanceof-4 failed";
        }
        if (!(b instanceof superClass[])) {
            return "array instanceof-5 failed";
        }
        if (!(b instanceof Object[])) {
            return "array instanceof-6 failed";
        }
        for (int i = 0; i < 10; ++i) {
            a[i] = new subClass();
            b[i] = new superClass();
        }
        b[4] = a[1];
        b[5] = null;
        a[2] = (subClass)b[4];
        a[2] = (subClass)b[5];
        boolean gotit = false;
        try {
            a[2] = (subClass)b[7];
        }
        catch (ClassCastException e) {
            gotit = true;
        }
        if (!gotit) {
            return "missing ClassCastException";
        }
        System.arraycopy(a, 0, b, 0, 10);
        for (int i = 0; i < 10; ++i) {
            a[i] = null;
        }
        System.arraycopy(a, 0, b, 0, 10);
        this.checkAllNull(b);
        System.arraycopy(b, 0, a, 0, 10);
        this.checkAllNull(a);
        this.checkAllNull(b);
        a[4] = new subClass();
        System.arraycopy(b, 0, a, 0, 10);
        this.checkAllNull(a);
        this.checkAllNull(b);
        boolean caught = false;
        try {
            System.arraycopy(null, 0, a, 0, 10);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            return "error: should have caught exception-1";
        }
        caught = false;
        try {
            System.arraycopy(b, 0, null, 0, 10);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            return "error: should have caught exception-2";
        }
        caught = false;
        try {
            System.arraycopy(b, 0, a, 0, 11);
        }
        catch (IndexOutOfBoundsException e) {
            caught = true;
        }
        if (!caught) {
            return "error: should have caught exception-3";
        }
        caught = false;
        try {
            System.arraycopy(b, 1, a, 0, 10);
        }
        catch (IndexOutOfBoundsException e) {
            caught = true;
        }
        if (!caught) {
            return "error: should have caught exception-4";
        }
        caught = false;
        try {
            System.arraycopy(b, -1, null, 100, 100);
        }
        catch (NullPointerException e) {
            caught = true;
        }
        if (!caught) {
            return "error: should have caught exception-5";
        }
        b[5] = new superClass();
        caught = false;
        try {
            System.arraycopy(b, 0, a, 0, 10);
        }
        catch (ArrayStoreException e) {
            caught = true;
        }
        if (!caught) {
            return "error: should have caught exception-6";
        }
        return null;
    }

    int dontDouble(int a) {
        this.throwArithmeticException(a);
        return 2 * a;
    }

    void throwArithmeticException(int a) {
        if (a == 1) {
            throw new ArithmeticException("fisk");
        }
        if (a == 1) {
            Context.getOut().println("should not print this");
        } else {
            Context.getOut().println("should print this");
        }
    }

    int testDup() {
        int b = 7;
        int a = 7;
        return a;
    }

    int testForLoop(int x, int y) {
        int a = 0;
        for (int i = x; i < y; ++i) {
            a += i * i;
        }
        return a;
    }

    String testArray() {
        Context.getOut().print("testArray:  ");
        int[] x = new int[6];
        x[4] = 3;
        x[3] = x[4];
        if (x[3] != 3) {
            return "got bad array value-";
        }
        double[][] y = new double[5][6];
        y[1][2] = 3.0;
        if (y[1][2] != 3.0) {
            return "got bad array value-2";
        }
        Stack[][][] fisk = new Stack[4][][];
        if (fisk[2] != null) {
            return "bad array initialization";
        }
        boolean hitit = false;
        try {
            for (int i = 0; i < 5; ++i) {
                x[i + 3] = i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            hitit = true;
        }
        if (!hitit) {
            return "missing exception";
        }
        if (x[4] != 1 || x[5] != 2) {
            return "missing side-effect";
        }
        return null;
    }

    boolean isPrime(int i) {
        if (i == 2) {
            return true;
        }
        if (i % 2 == 0) {
            return false;
        }
        int j = 3;
        while (j * j <= i) {
            if (i % j == 0) {
                return false;
            }
            j += 2;
        }
        return true;
    }

    void printPrimes() {
        Context.getOut().print("Primes less than 50: ");
        for (int i = 2; i < 50; ++i) {
            if (!this.isPrime(i)) continue;
            Context.getOut().print(i);
            Context.getOut().print(" ");
        }
        Context.getOut().println("");
    }

    public void Verify(String str) {
        if (null == str || str.equals("")) {
            Context.getOut().println("OK");
        } else {
            this.gotError = true;
            Context.getOut().println();
            Context.getOut().println("******************************************");
            Context.getOut().println(str);
            Context.getOut().println("******************************************");
        }
    }

    boolean checkRemL(long a, long b, long res) {
        boolean ok;
        boolean bl = ok = res == a % b;
        if (!ok) {
            Context.getOut().print("Failed: " + a + " % " + b + " = " + a % b);
            Context.getOut().println("   (should be: " + res);
        }
        return ok;
    }

    boolean checkRemD(double a, double b, double res) {
        boolean ok;
        boolean bl = ok = res == a % b;
        if (!ok) {
            Context.getOut().print("Failed: " + a + " % " + b + " = " + a % b);
            Context.getOut().println("   (should be: " + res);
        }
        return ok;
    }

    void printRemD(double a, double b) {
        Context.getOut().print(a + " % " + b + " = " + a % b);
    }

    String checkRemainders() {
        Context.getOut().print("checkRemainders: ");
        boolean ok = true;
        Context.getOut().print(" long ");
        if (!this.checkRemL(10L, 7L, 3L)) {
            ok = false;
        }
        if (!this.checkRemL(10L, -7L, 3L)) {
            ok = false;
        }
        if (!this.checkRemL(-10L, 7L, -3L)) {
            ok = false;
        }
        if (!this.checkRemL(-10L, -7L, -3L)) {
            ok = false;
        }
        if (!this.checkRemD(10.5, 7.0, 3.5)) {
            ok = false;
        }
        if (!this.checkRemD(10.5, -7.0, 3.5)) {
            ok = false;
        }
        if (!this.checkRemD(-10.5, 7.0, -3.5)) {
            ok = false;
        }
        if (!this.checkRemD(-10.5, -7.0, -3.5)) {
            ok = false;
        }
        if (!ok) {
            return "remainders failed";
        }
        Context.getOut().print("double ");
        return null;
    }

    boolean checkClose(String exprStr, double v, double r) {
        double m;
        double av = v;
        double ar = r;
        if (av < 0.0) {
            av = -av;
        }
        if (ar < 0.0) {
            ar = -ar;
        }
        if ((m = av > ar ? av : ar) == 0.0) {
            m = 1.0;
        }
        if ((v - r) / m > 1.0E-4) {
            Context.getOut().println(exprStr + " evaluated to: " + v + ", expected: " + r);
            return false;
        }
        return true;
    }

    String checkMathFcts() {
        Context.getOut().print("checkMathFcts: ");
        boolean ok = true;
        if (!this.checkClose("log(0.7)", Math.log(0.7), -0.356675)) {
            ok = false;
        }
        if (!this.checkClose("sin(0.7)", Math.sin(0.7), 0.644218)) {
            ok = false;
        }
        if (!this.checkClose("cos(0.7)", Math.cos(0.7), 0.764842)) {
            ok = false;
        }
        if (!this.checkClose("tan(0.7)", Math.tan(0.7), 0.842288)) {
            ok = false;
        }
        if (!this.checkClose("asin(0.7)", Math.asin(0.7), 0.775397)) {
            ok = false;
        }
        if (!this.checkClose("acos(0.7)", Math.acos(0.7), 0.795399)) {
            ok = false;
        }
        if (!this.checkClose("atan(0.7)", Math.atan(0.7), 0.610726)) {
            ok = false;
        }
        if (!ok) {
            return "Some math function failed";
        }
        return null;
    }

    void doIntWhileLoop() {
        for (int a = 0; a != 100000; ++a) {
        }
    }

    void doLongWhileLoop() {
        for (long a = 0L; a != 100000L; ++a) {
        }
    }

    String fiskString() {
        return "fisk";
    }

    int deepRecursion(int n, int sum) {
        if (n == 0) {
            return sum;
        }
        return this.deepRecursion(n - 1, n + sum);
    }

    String testDeepStack() {
        Context.getOut().print("testDeepStack: ");
        if (this.deepRecursion(5555, 0) != 15431790) {
            return "failed";
        }
        return null;
    }

    String testMisk() {
        Context.getOut().print("testMisk: ");
        String right = "-9223372036854775808";
        if (!right.equals("-9223372036854775808")) {
            return "(long)1 << 63 failed, returned: -9223372036854775808, should be: " + right;
        }
        if (!this.getClass().getName().equals(new PepTest().getClass().getName())) {
            return "Error(1): strings should have been equal!";
        }
        String str1 = "fisk";
        String str2 = "fisk";
        if (str1 != str2) {
            return "Error(2): strings should be identical!";
        }
        if (this.fiskString() != this.fiskString()) {
            return "Error(3): strings should be identical!";
        }
        if (new Double("3.14") != 3.14) {
            return "Error: Double.valueOf failed on 3.14";
        }
        if (new Double("-23.14") != -23.14) {
            return "Error: Double.valueOf failed on -23.14";
        }
        try {
            str1 = "java.lang.Thread";
            if (!str1.equals(Class.forName(str1).getName())) {
                return "Error(4): strings should be equal!";
            }
        }
        catch (Exception gotIt) {
            // empty catch block
        }
        return null;
    }

    String testGC() {
        Context.getOut().print("testGC: ");
        byte[][] bytesArrays = new byte[1000][];
        bytesArrays[0] = new byte[1000];
        Runtime.getRuntime().gc();
        if (!bytesArrays[0].getClass().getName().equals("[B")) {
            return "GC swallowed a live object!";
        }
        String cn = this.getClass().getName();
        Runtime.getRuntime().gc();
        if (!cn.equals(this.getClass().getName())) {
            return "got different class name";
        }
        return null;
    }

    public void instanceMain() {
        this.Verify(this.testIf());
        this.Verify(this.testArray());
        this.Verify(this.testBitOps());
        this.Verify(this.testFor());
        this.Verify(this.testDiv());
        this.Verify(this.testTableSwitch());
        this.Verify(this.testLookupSwitch());
        this.Verify(this.testHiddenField());
        this.Verify(this.checkRemainders());
        this.Verify(this.checkMathFcts());
        this.printPrimes();
        this.Verify(this.testExc1());
        this.Verify(this.testExc2());
        this.Verify(this.testExc3());
        this.Verify(this.testExc4());
        this.Verify(this.testExc5());
        this.Verify(this.testExc6());
        this.Verify(this.testExc7());
        this.Verify(this.loopExitContinueInExceptionHandler());
        this.Verify(this.testStringHash());
        this.Verify(this.testClone());
        this.Verify(this.testObjectArray());
        this.testClass();
        this.Verify(this.checkInstanceOf());
        this.Verify(this.checkInterfaceInstanceOf());
        this.Verify(this.testWaitNull());
        this.Verify(this.testVarAndMethodNameClash());
        this.Verify(this.testMisk());
        this.Verify(this.testGC());
        if (this.gotError) {
            Context.getOut().println("****** PepTest found an error ******");
        } else {
            Context.getOut().println("****** PepTest completed ******");
        }
    }

    public static void main(String[] args) {
        PepTest horse = new PepTest();
        horse.instanceMain();
        if (horse.gotError) {
            System.exit(1);
        }
    }
}

