/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.check;

import com.sun.tools.javac.main.JavaCompiler;
import spec.benchmarks.check.LoopBounds;
import spec.benchmarks.check.PepTest;
import spec.benchmarks.check.Sub;
import spec.benchmarks.check.Super;
import spec.harness.Context;
import spec.harness.KnownIssues;
import spec.harness.SpecJVMBenchmarkBase;
import spec.harness.results.BenchmarkResult;

public class Main
extends SpecJVMBenchmarkBase {
    public Main(BenchmarkResult bmResult, int threadId) {
        super(bmResult, threadId);
    }

    public static String testType() {
        return "functional";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runBenchmark() {
        boolean caughtIndex = false;
        boolean gotToFinally = false;
        try {
            int[] a = new int[10];
            for (int i = 0; i <= 10; ++i) {
                a[i] = i;
            }
            Context.getOut().println("Error: array bounds not checked");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            caughtIndex = true;
        }
        finally {
            gotToFinally = true;
        }
        if (!caughtIndex) {
            Context.getOut().println("1st bounds test error:\tindex exception not received");
        }
        if (!gotToFinally) {
            Context.getOut().println("1st bounds test error:\tfinally clause not executed");
        }
        if (caughtIndex && gotToFinally) {
            Context.getOut().println("1st bounds test:\tOK");
        }
        Main.checkSubclassing();
        LoopBounds.run();
        if (LoopBounds.gotError) {
            Context.getOut().println("2nd bounds test:\tfailed");
        } else {
            Context.getOut().println("2nd bounds test:\tOK");
        }
        if (!this.checkCompilerVersion()) {
            Context.getOut().println("Compiler version test:\tfailed");
            KnownIssues.isKnownIssueJavacVersion = true;
        }
        PepTest horse = new PepTest();
        horse.instanceMain();
        if (horse.gotError) {
            Context.getOut().println("PepTest failed");
        }
        return 0L;
    }

    private static void checkSubclassing() {
        Super sup = new Super(3);
        Sub sub = new Sub(3);
        Context.getOut().println(sup.getName() + ": " + sup.toString());
        Context.getOut().println(sub.getName() + ": " + sub.toString());
        Context.getOut().println("Super: prot=" + sup.getProtected() + ", priv=" + sup.getPrivate());
        Context.getOut().println("Sub:  prot=" + sub.getProtected() + ", priv=" + sub.getPrivate());
    }

    private boolean checkCompilerVersion() {
        return "1.7.0-opensource".equals(JavaCompiler.version());
    }

    public void harnessMain() {
        this.runBenchmark();
    }
}

