/*
 * Decompiled with CFR 0.152.
 */
package spec.benchmarks.check;

import spec.harness.Context;

public class FloatingPointCheck {
    public static boolean verbose = true;
    private static boolean error = false;
    public static final double doubleTiny = 9.9E-324;
    public static final double doubleSmall = 8.0;
    public static final double doubleBig = 256.0;
    public static final double doubleHuge = 8.988465674311579E307;
    public static final float floatTiny = 2.8E-45f;
    public static final float floatSmall = 8.0f;
    public static final float floatBig = 256.0f;
    public static final float floatHuge = 1.7014117E38f;
    public static final double doubleOne = 1.0;
    public static final double doubleEpsilon = Math.pow(2.0, -53.0);
    public static final float floatOne = 1.0f;
    public static final float floatEpsilon = (float)Math.pow(2.0, -24.0);

    public static void doubleRange(boolean print) {
        double check = 0.0;
        if (check != 0.0) {
            error = true;
            if (print) {
                Context.getOut().println("Ooops: double range too big near 0");
            }
        }
        if (print && verbose) {
            Context.getOut().println("\ttiny:             1.0E-323");
            Context.getOut().println("\ttiny/small:       0.0");
            Context.getOut().println("\t(tiny/small)*big: 0.0");
            Context.getOut().println("\tMIN_VALUE*big:    1.265E-321");
            Context.getOut().println("\t(tiny*big)/small: 3.16E-322");
        }
        if ((check = Double.POSITIVE_INFINITY) != Double.POSITIVE_INFINITY) {
            error = true;
            if (print) {
                Context.getOut().println("Ooops: double range too big near infinity");
            }
        }
        if (print && verbose) {
            Context.getOut().println("\thuge:             8.988465674311579E307");
            Context.getOut().println("\thuge*small:       Infinity");
            Context.getOut().println("\t(huge*small)/big: Infinity");
        }
    }

    public static void floatRange(boolean print) {
        float check = 0.0f;
        if ((double)check != 0.0) {
            error = true;
            if (print) {
                Context.getOut().println("Ooops: float range too big near 0");
            }
        }
        if (print && verbose) {
            Context.getOut().println("\ttiny:             2.8E-45");
            Context.getOut().println("\ttiny/small:       0.0");
            Context.getOut().println("\t(tiny/small)*big: 0.0");
            Context.getOut().println("\tMIN_VALUE*big:    3.59E-43");
            Context.getOut().println("\t(tiny*big)/small: 9.0E-44");
        }
        if ((check = Float.POSITIVE_INFINITY) != Float.POSITIVE_INFINITY) {
            error = true;
            if (print) {
                Context.getOut().println("Ooops: float range too big near infinity");
            }
        }
        if (print && verbose) {
            Context.getOut().println("\thuge:             1.7014117E38");
            Context.getOut().println("\thuge*small:       Infinity");
            Context.getOut().println("\t(huge*small)/big: Infinity");
        }
    }

    public static void doublePrecision(boolean print) {
        double check = 1.0 + doubleEpsilon - 1.0;
        if (check != 0.0) {
            error = true;
            if (print) {
                Context.getOut().println("Ooops: double precision too big near 1");
            }
        }
        if (print && verbose) {
            Context.getOut().println("\teps:\t" + doubleEpsilon);
            Context.getOut().println("\teps:\t0x" + Long.toString(Double.doubleToLongBits(doubleEpsilon), 16));
            Context.getOut().println("\t1+eps:\t" + (1.0 + doubleEpsilon));
            Context.getOut().println("\t(1+eps)-1:\t" + (1.0 + doubleEpsilon - 1.0));
        }
    }

    public static void floatPrecision(boolean print) {
        float check = 1.0f + floatEpsilon - 1.0f;
        if ((double)check != 0.0) {
            error = true;
            if (print) {
                Context.getOut().println("Ooops: float precision too big near 1");
            }
        }
        if (print && verbose) {
            Context.getOut().println("\teps:\t" + floatEpsilon);
            Context.getOut().println("\teps:\t0x" + Integer.toString(Float.floatToIntBits(floatEpsilon), 16));
            Context.getOut().println("\t1+eps:\t" + (1.0f + floatEpsilon));
            Context.getOut().println("\t(1+eps)-1:\t" + (1.0f + floatEpsilon - 1.0f));
        }
    }

    public static void test(boolean print) {
        FloatingPointCheck.doubleRange(print);
        FloatingPointCheck.doublePrecision(print);
        FloatingPointCheck.floatRange(print);
        FloatingPointCheck.floatPrecision(print);
    }

    public static void run(int length) {
        Context.getOut().println("FloatingPointCheck");
        for (int count = 0; count < 10000 * length; ++count) {
            FloatingPointCheck.test(false);
        }
        FloatingPointCheck.test(true);
        if (error) {
            Context.getOut().println("Error");
        } else {
            Context.getOut().println("OK");
        }
    }

    public static void main(String[] args) {
        FloatingPointCheck.run(100);
    }
}

