/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.tomcat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.security.MessageDigest;
import org.apache.commons.httpclient.HttpMethod;
import org.dacapo.harness.Digest;
import org.dacapo.tomcat.Session;

public abstract class Page {
    protected final String address;
    protected final String expectedDigest;
    protected final int expectedStatus;

    public Page(String address, int status, String digest) {
        this.address = address;
        this.expectedStatus = status;
        this.expectedDigest = digest;
    }

    protected static String readStream(InputStream responseStream) throws IOException {
        BufferedReader input = new BufferedReader(new InputStreamReader(responseStream));
        StringBuilder reply1 = new StringBuilder(4096);
        String line = input.readLine();
        while (line != null) {
            reply1.append(line);
            reply1.append('\n');
            line = input.readLine();
        }
        input.close();
        StringBuilder reply = reply1;
        String replyString = reply.toString();
        return replyString;
    }

    protected String stringDigest(String str) {
        MessageDigest md = Digest.create();
        byte[] buf = str.getBytes();
        for (int i = 0; i < str.length(); ++i) {
            md.update(buf[i]);
        }
        return Digest.toString(md.digest());
    }

    protected abstract boolean fetch(Session var1, File var2, boolean var3) throws IOException;

    public final boolean fetch(Session session, File logFile) throws IOException {
        return this.fetch(session, logFile, false);
    }

    protected final boolean fetch(Session session, HttpMethod method, File logFile, boolean keep) throws IOException {
        int iGetResultCode = session.httpClient.executeMethod(method);
        String strGetResponseBody = Page.readStream(method.getResponseBodyAsStream());
        String strGetResponseBodyLocalized = strGetResponseBody.replace("\n", System.getProperty("line.separator"));
        if (keep) {
            this.writeLog(logFile, strGetResponseBodyLocalized);
        }
        if (iGetResultCode != this.expectedStatus) {
            System.err.printf("URL %s returned status %d (expected %d)%n", this.address, iGetResultCode, this.expectedStatus);
            if (!keep) {
                this.writeLog(logFile, strGetResponseBodyLocalized);
            }
            return false;
        }
        if (this.expectedDigest == null) {
            return true;
        }
        String digestString = this.stringDigest(strGetResponseBody);
        boolean digestMatch = digestString.equals(this.expectedDigest);
        if (!digestMatch) {
            if (!keep) {
                this.writeLog(logFile, strGetResponseBodyLocalized);
            }
            System.err.printf("URL %s%n   expected %s%n   found    %s%n   response code %d, log file %s%n", this.address, this.expectedDigest, digestString, iGetResultCode, logFile.getName());
        }
        return digestMatch;
    }

    public String getAddress() {
        return this.address;
    }

    protected void writeLog(File logFile, String replyString) throws IOException {
        FileWriter output = new FileWriter(logFile);
        output.write(replyString);
        ((Writer)output).close();
    }

    protected String formatUrl(Session session) {
        return Page.formatUrl(session, this.address);
    }

    static String formatUrl(Session session, String addr) {
        String formattedUrl = String.format("http://localhost:%d%s", session.getPort(), addr);
        return formattedUrl;
    }
}

