/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.File;
import java.lang.reflect.Method;
import org.dacapo.harness.Benchmark;
import org.dacapo.parser.Config;

public class Tradebeans
extends Benchmark {
    private Method initializeMethod;

    public Tradebeans(Config config, File scratch) throws Exception {
        super(config, scratch, false);
        Class<?> clazz = Class.forName("org.dacapo.daytrader.Launcher", true, this.loader);
        this.initializeMethod = clazz.getMethod("initialize", File.class, Integer.TYPE, String.class, Boolean.TYPE);
        this.method = clazz.getMethod("performIteration", new Class[0]);
    }

    protected void prepare() throws Exception {
        Tradebeans.unpackZipFileResource("dat/daytrader.zip", this.scratch);
    }

    protected void prepare(String size) throws Exception {
        String[] args = this.config.preprocessArgs(size, this.scratch);
        String dtSize = "medium";
        if (args.length == 1) {
            dtSize = args[0];
        }
        this.initializeMethod.invoke(null, this.scratch, this.config.getThreadCount(size), dtSize, true);
    }

    public void cleanup() {
        System.out.println("Shutting down Geronimo...");
        if (!Tradebeans.getPreserve()) {
            Tradebeans.deleteTree(new File(this.scratch, "tradebeans"));
            Tradebeans.deleteTree(new File(this.scratch, "geronimo-jetty6-minimal-2.1.4"));
        }
    }

    public void iterate(String size) throws Exception {
        if (Tradebeans.getVerbose()) {
            System.out.println("tradebeans benchmark starting");
        }
        this.method.invoke(null, new Object[0]);
    }
}

