/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.File;
import java.lang.reflect.Constructor;
import org.dacapo.harness.Benchmark;
import org.dacapo.harness.DacapoException;
import org.dacapo.parser.Config;

public class Luindex
extends Benchmark {
    private final Object benchmark;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Luindex(Config config, File scratch) throws Exception {
        super(config, scratch);
        Class<?> clazz = Class.forName("org.dacapo.luindex.Index", true, this.loader);
        this.method = clazz.getMethod("main", File.class, String[].class);
        Constructor<?> cons = clazz.getConstructor(File.class);
        this.useBenchmarkClassLoader();
        try {
            this.benchmark = cons.newInstance(scratch);
        }
        finally {
            this.revertClassLoader();
        }
    }

    public void cleanup() {
        if (!Luindex.getPreserve()) {
            Luindex.deleteTree(new File(this.scratch, "luindex"));
        }
    }

    public void preIteration(String size) {
        if (Luindex.getPreserve() && this.getIteration() > 1) {
            Luindex.deleteTree(new File(this.scratch, "index"));
        }
    }

    public void iterate(String size) throws Exception {
        if (Luindex.getVerbose()) {
            System.out.println("luindex benchmark starting");
        }
        String[] args = this.config.preprocessArgs(size, this.scratch);
        File INDEX_DIR = new File(this.scratch, "index");
        if (INDEX_DIR.exists()) {
            System.out.println("Cannot save index to '" + INDEX_DIR + "' directory, please delete it first");
            throw new DacapoException("Cannot write to index directory");
        }
        this.method.invoke(this.benchmark, INDEX_DIR, args);
    }

    public void postIteration(String size) {
        if (!Luindex.getPreserve()) {
            Luindex.deleteTree(new File(this.scratch, "index"));
        }
    }
}

