/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.File;
import java.lang.reflect.Method;
import org.dacapo.harness.Benchmark;
import org.dacapo.parser.Config;

public class H2
extends Benchmark {
    private Object tpcc;
    private Method makeTPCC;
    private Method prepareTPCC;
    private Method preIterationTPCC;
    private Method iterationTPCC;
    private Method postIterationTPCC;

    public H2(Config config, File scratch) throws Exception {
        super(config, scratch, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepare() throws Exception {
        this.useBenchmarkClassLoader();
        try {
            Class<?> tpccClazz = Class.forName("org.dacapo.h2.TPCC", true, this.loader);
            this.makeTPCC = tpccClazz.getMethod("make", Config.class, File.class, Boolean.class, Boolean.class);
            this.prepareTPCC = tpccClazz.getMethod("prepare", String.class);
            this.preIterationTPCC = tpccClazz.getMethod("preIteration", String.class);
            this.iterationTPCC = tpccClazz.getMethod("iteration", String.class);
            this.postIterationTPCC = tpccClazz.getMethod("postIteration", String.class);
            this.tpcc = this.makeTPCC.invoke(null, this.config, this.scratch, H2.getVerbose(), H2.getPreserve());
        }
        finally {
            this.revertClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(String size) throws Exception {
        this.useBenchmarkClassLoader();
        try {
            this.prepareTPCC.invoke(this.tpcc, size);
        }
        finally {
            this.revertClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preIteration(String size) throws Exception {
        this.useBenchmarkClassLoader();
        try {
            this.preIterationTPCC.invoke(this.tpcc, size);
        }
        finally {
            this.revertClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(String size) throws Exception {
        this.useBenchmarkClassLoader();
        try {
            this.iterationTPCC.invoke(this.tpcc, size);
        }
        finally {
            this.revertClassLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postIteration(String size) throws Exception {
        this.useBenchmarkClassLoader();
        try {
            this.postIterationTPCC.invoke(this.tpcc, size);
        }
        finally {
            this.revertClassLoader();
            super.postIteration(size);
        }
    }

    public void cleanup() {
        this.tpcc = null;
        this.makeTPCC = null;
        this.prepareTPCC = null;
        this.preIterationTPCC = null;
        this.iterationTPCC = null;
        this.postIterationTPCC = null;
        super.cleanup();
    }
}

