/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.dacapo.harness.Callback;
import org.dacapo.parser.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineArgs {
    public static final int EXIT_OK = 0;
    public static final int EXIT_MISSING_CALLBACK = 2;
    public static final int EXIT_BAD_CALLBACK = 3;
    public static final int EXIT_BAD_COMMANDLINE = 4;
    public static final int EXIT_UNKNOWN_BENCHMARK = 9;
    public static final int EXIT_MISSING_BENCHMARKS = 10;
    public static final String RELEASE_NOTES = "RELEASE_NOTES.txt";
    public static final String DEFAULT_SIZE = "default";
    public static final String DEFAULT_SCRATCH_DIRECTORY = "./scratch";
    public static final String DEFAULT_MAX_ITERATIONS = "20";
    public static final String DEFAULT_WINDOW_SIZE = "3";
    public static final String DEFAULT_VARIANCE = "3.0";
    public static final String DEFAULT_ITERATIONS = "1";
    public static final String DEFAULT_THREAD_COUNT = "0";
    public static final String DEFAULT_THREAD_FACTOR = "0";
    private static final String OPT_CALLBACK = "callback";
    private static final String OPT_HELP = "help";
    private static final String OPT_RELEASE_NOTES = "release-notes";
    private static final String OPT_LIST_BENCHMARKS = "list-benchmarks";
    private static final String OPT_INFORMATION = "information";
    private static final String OPT_SIZE = "size";
    private static final String OPT_SCRATCH_DIRECTORY = "scratch-directory";
    private static final String OPT_CONVERGE = "converge";
    private static final String OPT_MAX_ITERATIONS = "max-iterations";
    private static final String OPT_VARIANCE = "variance";
    private static final String OPT_WINDOW = "window";
    private static final String OPT_ITERATIONS = "iterations";
    private static final String OPT_DEBUG = "debug";
    private static final String OPT_IGNORE_VALIDATION = "ignore-validation";
    private static final String OPT_NO_DIGEST_OUTPUT = "no-digest-output";
    private static final String OPT_NO_VALIDATION = "no-validation";
    private static final String OPT_PRESERVE = "preserve";
    private static final String OPT_VALIDATION_REPORT = "validation-report";
    private static final String OPT_CONFIG = "config";
    private static final String OPT_VERBOSE = "verbose";
    private static final String OPT_NO_PRE_ITERATION_GC = "no-pre-iteration-gc";
    private static final String OPT_THREAD_COUNT = "thread-count";
    private static final String OPT_THREAD_FACTOR = "thread-factor";
    private static final Option[] OPTIONS = new Option[]{CommandLineArgs.makeOption("c", "callback", "Use class <callback> to bracket benchmark runs", "callback"), CommandLineArgs.makeOption("h", "help", "Print this help", null), CommandLineArgs.makeOption("r", "release-notes", "Print the release notes", null), CommandLineArgs.makeOption("l", "list-benchmarks", "List available benchmarks", null), CommandLineArgs.makeOption("i", "information", "Display benchmark information", null), CommandLineArgs.makeOption("s", "size", "Size of input data", "SIZE"), CommandLineArgs.makeOption(null, "scratch-directory", "Specify an alternate scratch directory <dir>", "dir"), CommandLineArgs.makeOption("C", "converge", "Allow benchmark times to converge before timing", null), CommandLineArgs.makeOption(null, "max-iterations", "Run a max of <max_iterations> iterations (default 20)", "max_iterations"), CommandLineArgs.makeOption(null, "variance", "Target coefficient of variation <pct> (default 3.0)", "pct"), CommandLineArgs.makeOption(null, "window", "Measure variance over <window> runs (default 3)", "window"), CommandLineArgs.makeOption("n", "iterations", "Run the benchmark <iter> times", "iter"), CommandLineArgs.makeOption("d", "debug", "Verbose debugging information", null), CommandLineArgs.makeOption(null, "ignore-validation", "Don't halt on validation failure", null), CommandLineArgs.makeOption(null, "no-digest-output", "Turn off SHA1 digest of stdout/stderr", null), CommandLineArgs.makeOption(null, "no-validation", "Don't validate at all", null), CommandLineArgs.makeOption(null, "preserve", "Preserve output files (debug)", null), CommandLineArgs.makeOption(null, "validation-report", "Report digests, line counts etc", "report_file"), CommandLineArgs.makeOption(null, "config", null, "config_file"), CommandLineArgs.makeOption(null, "no-pre-iteration-gc", "Skip performing System.gc() before the start of each iteration", null), CommandLineArgs.makeOption("t", "thread-count", "Set the thread count to drive the workload (mutually exclusive -k)", "thread_count"), CommandLineArgs.makeOption("k", "thread-factor", "Set the number of threads per CPU to drive the workload (mutually exclusive with -t)", "thread_per_cpu"), CommandLineArgs.makeOption("v", "verbose", "Verbose output", null)};
    private static CommandLineParser parser = new PosixParser();
    private static Options options = new Options();
    private static Options visibleOptions = new Options();
    private CommandLine line;
    private Callback callback;
    private List<String> benchmarks;

    CommandLineArgs(String[] args) throws Exception {
        for (int i = 0; i < OPTIONS.length; ++i) {
            options.addOption(OPTIONS[i]);
            if (OPTIONS[i].getDescription() == null) continue;
            visibleOptions.addOption(OPTIONS[i]);
        }
        this.callback = null;
        this.benchmarks = new ArrayList<String>();
        try {
            boolean reportAndExitOk = false;
            this.line = parser.parse(options, args);
            if (this.line.hasOption(OPT_LIST_BENCHMARKS)) {
                CommandLineArgs.printBenchmarks();
                reportAndExitOk = true;
            }
            if (this.line.hasOption(OPT_RELEASE_NOTES)) {
                CommandLineArgs.printReleaseNotes();
                reportAndExitOk = true;
            }
            if (this.line.hasOption(OPT_HELP)) {
                CommandLineArgs.printUsage();
                reportAndExitOk = true;
            }
            if (this.line.hasOption(OPT_THREAD_FACTOR) && this.line.hasOption(OPT_THREAD_COUNT)) {
                throw new ParseException("Cannot specify -t and -k options.");
            }
            if (reportAndExitOk) {
                System.exit(0);
            }
        }
        catch (ParseException e) {
            System.err.println("Command line exception: " + e.getMessage());
            System.exit(4);
        }
        catch (Exception e) {
            System.err.println("Exception processing command line values: " + e.getMessage());
            System.exit(4);
        }
        this.defineCallback();
        if (this.line.getArgList().isEmpty() && !this.line.hasOption(OPT_CONFIG)) {
            CommandLineArgs.printUsage();
            System.exit(10);
        } else if (this.line.hasOption(OPT_CONFIG) && !this.line.getArgList().isEmpty()) {
            System.err.println("You may only specify a cnf or a list of benchmarks, but not both");
            System.exit(4);
        }
        List<String> benchmarkSet = CommandLineArgs.extractBenchmarkSet();
        if (!this.line.getArgList().isEmpty()) {
            for (Object bm : this.line.getArgList()) {
                if (benchmarkSet.contains(bm)) {
                    this.benchmarks.add((String)bm);
                    continue;
                }
                System.err.println("Unknown benchmark: " + bm);
                System.exit(9);
            }
        } else {
            File cnfFile = new File(this.line.getOptionValue(OPT_CONFIG));
            if (!cnfFile.canRead()) {
                System.err.println("Unknown config file: " + cnfFile.getAbsolutePath());
                System.exit(9);
            }
            Config config = Config.parse(cnfFile);
            if (benchmarkSet.contains(config.name)) {
                this.benchmarks.add(config.name);
            } else {
                System.err.println("Unknown benchmark specified in cnf file: " + config.name);
                System.exit(9);
            }
        }
    }

    static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("DaCapo Benchmark suite", visibleOptions);
    }

    static void printReleaseNotes() throws IOException {
        String line;
        BufferedReader releaseNotes = new BufferedReader(new InputStreamReader(CommandLineArgs.class.getClassLoader().getResourceAsStream(RELEASE_NOTES)));
        while ((line = releaseNotes.readLine()) != null) {
            System.out.println(line);
        }
    }

    static void printBenchmarks() throws IOException {
        Iterator<String> iter = new TreeSet<String>(CommandLineArgs.extractBenchmarkSet()).iterator();
        while (iter.hasNext()) {
            System.out.print(iter.next());
            if (!iter.hasNext()) continue;
            System.out.print(" ");
        }
        System.out.println();
    }

    static List<String> extractBenchmarkSet() throws IOException {
        ArrayList<String> benchmarks;
        block3: {
            File dir;
            String protocol;
            URL url;
            block2: {
                benchmarks = new ArrayList<String>();
                url = CommandLineArgs.class.getClassLoader().getResource("cnf");
                protocol = url.getProtocol();
                if (!protocol.equals("jar")) break block2;
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                Enumeration<JarEntry> entries = jarConnection.getJarFile().entries();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement().getName();
                    if (!entry.endsWith(".cnf")) continue;
                    entry = entry.replace("cnf/", "").replace(".cnf", "");
                    benchmarks.add(entry);
                }
                break block3;
            }
            if (!protocol.equals("file") || !(dir = new File(url.getFile())).isDirectory()) break block3;
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String entry = files[i].toString();
                entry = entry.substring(entry.lastIndexOf(47) + 1, entry.length());
                entry = entry.replace(".cnf", "");
                benchmarks.add(entry);
            }
        }
        return benchmarks;
    }

    public Iterable<String> benchmarks() {
        return this.benchmarks;
    }

    public boolean getVerbose() {
        return this.line.hasOption(OPT_VERBOSE);
    }

    public Methodology getMethodology() {
        return this.line.hasOption(OPT_CONVERGE) ? Methodology.CONVERGE : Methodology.ITERATE;
    }

    public double getTargetVar() {
        return Double.parseDouble(this.line.getOptionValue(OPT_VARIANCE, DEFAULT_VARIANCE)) / 100.0;
    }

    public int getWindow() {
        return Integer.parseInt(this.line.getOptionValue(OPT_WINDOW, DEFAULT_WINDOW_SIZE));
    }

    public int getMaxIterations() {
        return Integer.parseInt(this.line.getOptionValue(OPT_MAX_ITERATIONS, DEFAULT_MAX_ITERATIONS));
    }

    public boolean getIgnoreValidation() {
        return this.line.hasOption(OPT_IGNORE_VALIDATION);
    }

    public int getIterations() {
        return Integer.parseInt(this.line.getOptionValue(OPT_ITERATIONS, DEFAULT_ITERATIONS));
    }

    public String getSize() {
        return this.line.getOptionValue(OPT_SIZE, DEFAULT_SIZE);
    }

    public String getScratchDir() {
        return this.line.getOptionValue(OPT_SCRATCH_DIRECTORY, DEFAULT_SCRATCH_DIRECTORY);
    }

    public Callback getCallback() {
        return this.callback;
    }

    public String getCnfOverride() {
        return this.line.getOptionValue(OPT_CONFIG, null);
    }

    public boolean getInformation() {
        return this.line.hasOption(OPT_INFORMATION);
    }

    public boolean getSilent() {
        return !this.getVerbose();
    }

    public boolean getDebug() {
        return this.line.hasOption(OPT_DEBUG);
    }

    public boolean getPreserve() {
        return this.line.hasOption(OPT_PRESERVE);
    }

    public boolean getValidateOutput() {
        return !this.line.hasOption(OPT_NO_DIGEST_OUTPUT);
    }

    public boolean getValidate() {
        return !this.line.hasOption(OPT_NO_VALIDATION);
    }

    public String getValidationReport() {
        return this.line.getOptionValue(OPT_VALIDATION_REPORT, null);
    }

    public boolean getPreIterationGC() {
        return !this.line.hasOption(OPT_NO_PRE_ITERATION_GC);
    }

    public String getThreadCount() {
        return this.line.getOptionValue(OPT_THREAD_COUNT, "0");
    }

    public String getThreadFactor() {
        return this.line.getOptionValue(OPT_THREAD_FACTOR, "0");
    }

    public List<String> getArgList() {
        return this.line.getArgList();
    }

    public String[] getArgs() {
        return this.line.getArgs();
    }

    private void defineCallback() throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.line.hasOption(OPT_CALLBACK)) {
            Class<?> cls = null;
            try {
                cls = Class.forName(this.line.getOptionValue(OPT_CALLBACK));
            }
            catch (Exception e) {
                System.err.println(e);
                System.err.println("Could not find callback class " + this.line.getOptionValue(OPT_CALLBACK));
                System.exit(2);
            }
            if (!Callback.class.isAssignableFrom(cls)) {
                System.err.println(this.line.getOptionValue(OPT_CALLBACK) + " is not an instance of Callback");
                System.exit(3);
            } else {
                Constructor<?> cons = cls.getConstructor(CommandLineArgs.class);
                this.callback = (Callback)cons.newInstance(this);
            }
        }
        if (this.getCallback() == null) {
            this.callback = new Callback(this);
        }
    }

    private static Option makeOption(String shortName, String longName, String description, String argName) {
        assert (longName != null);
        Option option = new Option(shortName, longName, argName != null, description);
        if (argName != null) {
            option.setValueSeparator('=');
            option.setArgName(argName);
        }
        return option;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Methodology {
        ITERATE,
        CONVERGE;

    }
}

