/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Util {
    public static String[] getJavaClassLibs() {
        String bootclasspathProperty = System.getProperty("sun.boot.class.path");
        if (!(bootclasspathProperty != null && bootclasspathProperty.length() != 0 || (bootclasspathProperty = System.getProperty("vm.boot.class.path")) != null && bootclasspathProperty.length() != 0)) {
            bootclasspathProperty = System.getProperty("org.apache.harmony.boot.class.path");
        }
        String[] jars = null;
        if (bootclasspathProperty != null && bootclasspathProperty.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(bootclasspathProperty, File.pathSeparator);
            int size = tokenizer.countTokens();
            jars = new String[size];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String fileName = Util.toNativePath(tokenizer.nextToken());
                if (!new File(fileName).exists()) continue;
                jars[i] = fileName;
                ++i;
            }
            if (size != i) {
                String[] stringArray = jars;
                jars = new String[i];
                System.arraycopy(stringArray, 0, jars, 0, i);
            }
        } else {
            String jreDir = Util.getJREDirectory();
            String osName = System.getProperty("os.name");
            if (jreDir == null) {
                return new String[0];
            }
            if (osName.startsWith("Mac")) {
                return new String[]{Util.toNativePath(jreDir + "/../Classes/classes.jar")};
            }
            String vmName = System.getProperty("java.vm.name");
            if ("J9".equals(vmName)) {
                return new String[]{Util.toNativePath(jreDir + "/lib/jclMax/classes.zip")};
            }
            String[] jarsNames = null;
            ArrayList paths = new ArrayList();
            if ("DRLVM".equals(vmName)) {
                FilenameFilter jarFilter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar") & !name.endsWith("-src.jar");
                    }
                };
                jarsNames = new File(jreDir + "/lib/boot/").list(jarFilter);
                Util.addJarEntries(jreDir + "/lib/boot/", jarsNames, paths);
            } else {
                jarsNames = new String[]{"/lib/vm.jar", "/lib/rt.jar", "/lib/core.jar", "/lib/security.jar", "/lib/xml.jar", "/lib/graphics.jar"};
                Util.addJarEntries(jreDir, jarsNames, paths);
            }
            jars = new String[paths.size()];
            paths.toArray(jars);
        }
        return jars;
    }

    private static void addJarEntries(String jreDir, String[] jarNames, ArrayList paths) {
        int max = jarNames.length;
        for (int i = 0; i < max; ++i) {
            String currentName = jreDir + jarNames[i];
            File f = new File(currentName);
            if (!f.exists()) continue;
            paths.add(Util.toNativePath(currentName));
        }
    }

    public static String getJREDirectory() {
        return System.getProperty("java.home");
    }

    public static String toNativePath(String path) {
        String nativePath = path.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        return nativePath.endsWith("/") || nativePath.endsWith("\\") ? nativePath.substring(0, nativePath.length() - 1) : nativePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String zipPath, String destDirPath) throws IOException {
        FileInputStream zipIn = new FileInputStream(zipPath);
        byte[] buf = new byte[8192];
        File destDir = new File(destDirPath);
        ZipInputStream zis = new ZipInputStream(zipIn);
        FileOutputStream fos = null;
        try {
            ZipEntry zEntry;
            while ((zEntry = zis.getNextEntry()) != null) {
                if (zEntry.isDirectory()) {
                    new File(destDir, zEntry.getName()).mkdirs();
                    continue;
                }
                String filePath = zEntry.getName();
                int lastSeparator = filePath.lastIndexOf("/");
                String fileDir = "";
                if (lastSeparator >= 0) {
                    fileDir = filePath.substring(0, lastSeparator);
                }
                new File(destDir, fileDir).mkdirs();
                File outFile = new File(destDir, filePath);
                fos = new FileOutputStream(outFile);
                int n = 0;
                while ((n = zis.read(buf)) >= 0) {
                    fos.write(buf, 0, n);
                }
                fos.close();
            }
        }
        catch (IOException ioe) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                ((InputStream)zipIn).close();
                if (zis != null) {
                    zis.close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

