/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.util;

public class AbstractCompilerTest {
    public static final int F_1_3 = 1;
    public static final int F_1_4 = 2;
    public static final int F_1_5 = 4;
    public static final int F_1_6 = 8;
    public static final int F_1_7 = 16;
    public static final boolean RUN_JAVAC = "enabled".equals(System.getProperty("run.javac"));
    private static final int UNINITIALIZED = -1;
    private static final int NONE = 0;
    private static int possibleComplianceLevels = -1;

    public static int getPossibleComplianceLevels() {
        if (possibleComplianceLevels == -1) {
            String compliance = System.getProperty("compliance");
            if (compliance != null) {
                if ("1.3".equals(compliance)) {
                    possibleComplianceLevels = RUN_JAVAC ? 0 : 1;
                } else if ("1.4".equals(compliance)) {
                    possibleComplianceLevels = RUN_JAVAC ? 0 : 2;
                } else if ("1.5".equals(compliance)) {
                    possibleComplianceLevels = 4;
                } else if ("1.6".equals(compliance)) {
                    possibleComplianceLevels = 8;
                } else if ("1.7".equals(compliance)) {
                    possibleComplianceLevels = 16;
                } else {
                    System.out.println("Invalid compliance specified (" + compliance + ")");
                    System.out.print("Use one of ");
                    System.out.print("1.3, ");
                    System.out.print("1.4, ");
                    System.out.print("1.5, ");
                    System.out.print("1.6, ");
                    System.out.println("1.7");
                    System.out.println("Defaulting to all possible compliances");
                }
            }
            if (possibleComplianceLevels == -1) {
                String specVersion = System.getProperty("java.specification.version");
                if (!RUN_JAVAC) {
                    boolean canRun1_7;
                    boolean canRun1_6;
                    boolean canRun1_5;
                    boolean canRun1_4;
                    possibleComplianceLevels = 1;
                    boolean bl = canRun1_4 = !"1.0".equals(specVersion) && !"1.1".equals(specVersion) && !"1.2".equals(specVersion) && !"1.3".equals(specVersion);
                    if (canRun1_4) {
                        possibleComplianceLevels |= 2;
                    }
                    boolean bl2 = canRun1_5 = canRun1_4 && !"1.4".equals(specVersion);
                    if (canRun1_5) {
                        possibleComplianceLevels |= 4;
                    }
                    boolean bl3 = canRun1_6 = canRun1_5 && !"1.5".equals(specVersion);
                    if (canRun1_6) {
                        possibleComplianceLevels |= 8;
                    }
                    boolean bl4 = canRun1_7 = canRun1_6 && !"1.6".equals(specVersion);
                    if (canRun1_7) {
                        possibleComplianceLevels |= 0x10;
                    }
                } else if ("1.0".equals(specVersion) || "1.1".equals(specVersion) || "1.2".equals(specVersion) || "1.3".equals(specVersion) || "1.4".equals(specVersion)) {
                    possibleComplianceLevels = 0;
                } else {
                    possibleComplianceLevels = 4;
                    if (!"1.5".equals(specVersion)) {
                        possibleComplianceLevels |= 8;
                        if (!"1.6".equals(specVersion)) {
                            possibleComplianceLevels |= 0x10;
                        }
                    }
                }
            }
        }
        if (possibleComplianceLevels == 0) {
            System.out.println("Skipping all compliances (found none compatible with run.javac=enabled).");
        }
        return possibleComplianceLevels;
    }
}

