/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.TestingEnvironment;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;

public abstract class FullSourceWorkspaceTests {
    static final boolean DEBUG = "true".equals(System.getProperty("debug"));
    static final boolean PRINT = "true".equals(System.getProperty("print"));
    static final boolean DACAPO_PRINT = true;
    static final Hashtable INITIAL_OPTIONS = JavaCore.getOptions();
    protected static TestingEnvironment ENV = null;
    protected static IJavaProject[] ALL_PROJECTS;
    protected static IJavaProject JDT_CORE_PROJECT;
    protected static ICompilationUnit PARSER_WORKING_COPY;
    protected static final String BIG_PROJECT_NAME = "BigProject";
    protected static final String FULL_SOURCE_ZIP_REL_PATH = "full-source-R3_0";
    static final String COMPLIANCE;
    protected static IndexManager INDEX_MANAGER;
    public static final boolean VERBOSE = false;

    protected static String compliance() {
        String compliance = null;
        if ("1.3".equals(COMPLIANCE)) {
            compliance = "1.3";
        } else if ("1.4".equals(COMPLIANCE)) {
            compliance = "1.4";
        } else if ("1.5".equals(COMPLIANCE) || "5.0".equals(COMPLIANCE)) {
            compliance = "1.5";
        } else if ("1.6".equals(COMPLIANCE) || "6.0".equals(COMPLIANCE)) {
            compliance = "1.6";
        }
        return compliance;
    }

    public static void setup(boolean large) {
        try {
            if (ENV == null) {
                System.out.print("Initialize workspace ");
                ENV = new TestingEnvironment();
                ENV.openEmptyWorkspace();
                FullSourceWorkspaceTests.setUpFullSourceWorkspace(large);
                System.out.println();
            }
        }
        catch (Exception e) {
            System.err.println("Error creating workspace!");
            e.printStackTrace();
        }
    }

    public static void unzipWorkSpace(boolean large) {
        System.out.print("Unzip workspace ");
        try {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            File targetWorkspaceDir = workspaceRoot.getLocation().toFile();
            String targetWorkspacePath = targetWorkspaceDir.getCanonicalPath();
            FullSourceWorkspaceTests.deleteWorkspace();
            String fullSourceZipPath = targetWorkspaceDir.getParent() + File.separator + FULL_SOURCE_ZIP_REL_PATH;
            FullSourceWorkspaceTests.unzip(fullSourceZipPath + "-default.zip", targetWorkspacePath);
            if (large) {
                FullSourceWorkspaceTests.unzip(fullSourceZipPath + "-large.zip", targetWorkspacePath);
            }
        }
        catch (IOException e) {
            System.err.println("Error creating workspace!");
            e.printStackTrace();
        }
        System.out.println();
    }

    private static void unzip(String sourceZipPath, String targetWorkspacePath) throws IOException {
        Util.unzip(sourceZipPath, targetWorkspacePath);
    }

    public static void tearDown() {
        System.out.print("Delete workspace ");
        ENV.close();
        ENV = null;
        FullSourceWorkspaceTests.deleteWorkspace();
        JavaCore.setOptions((Hashtable)INITIAL_OPTIONS);
        System.out.println();
    }

    private static void deleteWorkspace() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().delete(true, null);
            ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().delete();
        }
        catch (Exception e) {
            System.err.println("Problem deleting workspace");
            e.printStackTrace();
        }
    }

    Map clearOptions(Map options) {
        Iterator iter = options.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)options.get(key);
            if ("error".equals(value) || "warning".equals(value)) {
                options.put(key, "ignore");
                continue;
            }
            if (!"enabled".equals(value)) continue;
            options.put(key, "disabled");
        }
        options.put("org.eclipse.jdt.core.compiler.taskTags", "");
        return options;
    }

    protected IClassFile getClassFile(IJavaProject project, String rootPath, String packageName, String className) throws JavaModelException {
        IPackageFragment pkg = this.getPackageFragment(project, rootPath, packageName);
        if (pkg == null) {
            return null;
        }
        return pkg.getClassFile(className);
    }

    protected ICompilationUnit getCompilationUnit(String projectName, String packageName, String unitName) throws CoreException {
        IJavaProject javaProject = this.getProject(projectName);
        if (javaProject == null) {
            return null;
        }
        IType type = javaProject.findType(packageName, unitName);
        if (type != null) {
            return type.getCompilationUnit();
        }
        return null;
    }

    protected IPackageFragment getPackageFragment(IJavaProject project, String rootPath, String packageName) throws JavaModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot(project, rootPath);
        if (root == null) {
            return null;
        }
        return root.getPackageFragment(packageName);
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IJavaProject project, String rootPath) throws JavaModelException {
        if (project == null) {
            return null;
        }
        Path path = new Path(rootPath);
        if (path.isAbsolute()) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = workspaceRoot.findMember((IPath)path);
            IPackageFragmentRoot root = resource == null ? project.getPackageFragmentRoot(rootPath) : project.getPackageFragmentRoot(resource);
            return root;
        }
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        if (roots == null || roots.length == 0) {
            return null;
        }
        for (int i = 0; i < roots.length; ++i) {
            IPackageFragmentRoot root = roots[i];
            if (root.isExternal() || !root.getUnderlyingResource().getProjectRelativePath().equals(path)) continue;
            return root;
        }
        return this.getExternalJarFile(project, rootPath);
    }

    protected IPackageFragmentRoot getExternalJarFile(IJavaProject project, String jarSimpleName) throws JavaModelException {
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        if (roots == null || roots.length == 0) {
            return null;
        }
        for (int i = 0; i < roots.length; ++i) {
            IPackageFragmentRoot root = roots[i];
            if (!root.isExternal() || !root.getElementName().equals(jarSimpleName)) continue;
            return root;
        }
        return null;
    }

    protected IJavaProject getProject(String projectName) {
        int length = ALL_PROJECTS.length;
        for (int i = 0; i < length; ++i) {
            if (!ALL_PROJECTS[i].getElementName().equals(projectName)) continue;
            return ALL_PROJECTS[i];
        }
        return null;
    }

    static void setUpFullSourceWorkspace(boolean large) throws Exception {
        int dirLength;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        String targetWorkspacePath = workspaceRoot.getLocation().toFile().getCanonicalPath();
        IEclipsePreferences resourcesPreferences = new InstanceScope().getNode("org.eclipse.core.resources");
        resourcesPreferences.put("refresh.enabled", "false");
        workspace.getDescription().setSnapshotInterval(Long.MAX_VALUE);
        workspace.getDescription().setAutoBuilding(false);
        File wkspDir = new File(targetWorkspacePath);
        FullSourceProjectsFilter filter = new FullSourceProjectsFilter();
        File[] directories = wkspDir.listFiles(filter);
        int n = dirLength = directories == null ? 0 : directories.length;
        if (dirLength < 5) {
            System.out.println("Workspace empty!");
            FullSourceWorkspaceTests.unzipWorkSpace(large);
        }
        for (int i = 0; i < dirLength; ++i) {
            String dirName = directories[i].getName();
            IProject project = workspaceRoot.getProject(dirName);
            if (project.exists()) {
                System.out.print("o");
                ENV.addProject(project);
                continue;
            }
            System.out.print(".");
            ENV.addProject(dirName);
        }
        String jreLibPath = JavaCore.getClasspathVariable((String)"JRE_LIB").toOSString();
        String[] jdkLibs = Util.getJavaClassLibs();
        int jdkLibsLength = jdkLibs.length;
        IClasspathEntry[] jdkEntries = new IClasspathEntry[jdkLibsLength];
        int jdkEntriesCount = 0;
        for (int i = 0; i < jdkLibsLength; ++i) {
            if (jdkLibs[i].equals(jreLibPath)) continue;
            jdkEntries[jdkEntriesCount++] = JavaCore.newLibraryEntry((IPath)new Path(jdkLibs[i]), null, null);
        }
        ALL_PROJECTS = JavaCore.create((IWorkspaceRoot)workspaceRoot).getJavaProjects();
        int projectsLength = ALL_PROJECTS.length;
        for (int i = 0; i < projectsLength; ++i) {
            String projectName = ALL_PROJECTS[i].getElementName();
            if (BIG_PROJECT_NAME.equals(projectName)) continue;
            if ("org.eclipse.jdt.core".equals(projectName)) {
                JDT_CORE_PROJECT = ALL_PROJECTS[i];
            }
            IClasspathEntry[] entries = ALL_PROJECTS[i].getRawClasspath();
            int entriesLength = entries.length;
            try {
                IClasspathEntry[] iClasspathEntryArray = entries;
                entries = new IClasspathEntry[jdkEntriesCount + entriesLength];
                System.arraycopy(iClasspathEntryArray, 0, entries, 0, entriesLength);
                System.arraycopy(jdkEntries, 0, entries, entriesLength, jdkEntriesCount);
                ALL_PROJECTS[i].setRawClasspath(entries, null);
                continue;
            }
            catch (CoreException jme) {
                if (jme.getStatus().getCode() == 977) continue;
                throw jme;
            }
        }
    }

    protected List getProjectCompilationUnits(IJavaProject javaProject) throws CoreException {
        IPackageFragmentRoot[] fragmentRoots = javaProject.getPackageFragmentRoots();
        int length = fragmentRoots.length;
        ArrayList<ICompilationUnit> allUnits = new ArrayList<ICompilationUnit>();
        for (int i = 0; i < length; ++i) {
            if (fragmentRoots[i] instanceof JarPackageFragmentRoot) continue;
            IJavaElement[] packages = fragmentRoots[i].getChildren();
            for (int k = 0; k < packages.length; ++k) {
                IPackageFragment pack = (IPackageFragment)packages[k];
                ICompilationUnit[] units = pack.getCompilationUnits();
                for (int u = 0; u < units.length; ++u) {
                    allUnits.add(units[u]);
                }
            }
        }
        return allUnits;
    }

    protected Hashtable warningOptions(int kind) {
        Hashtable optionsMap = JavaCore.getDefaultOptions();
        if (kind == 0) {
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        } else {
            this.clearOptions(optionsMap);
            boolean all = kind == 1;
            String generate = all ? "generate" : "do not generate";
            String warning = all ? "warning" : "ignore";
            String enabled = all ? "enabled" : "disabled";
            String preserve = all ? "optimize out" : "preserve";
            optionsMap.put("org.eclipse.jdt.core.compiler.debug.localVariable", generate);
            optionsMap.put("org.eclipse.jdt.core.compiler.debug.lineNumber", generate);
            optionsMap.put("org.eclipse.jdt.core.compiler.debug.sourceFile", generate);
            optionsMap.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", preserve);
            optionsMap.put("org.eclipse.jdt.core.compiler.doc.comment.support", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.deprecation", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedImport", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", warning);
            optionsMap.put("org.eclipse.jdt.core.compiler.taskTags", all ? "TODO,FIXME,XXX" : "");
            optionsMap.put("org.eclipse.jdt.core.compiler.taskPriorities", all ? "NORMAL,HIGH,NORMAL" : "");
            optionsMap.put("org.eclipse.jdt.core.compiler.taskCaseSensitive", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", enabled);
            optionsMap.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", enabled);
        }
        optionsMap.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        optionsMap.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "ignore");
        optionsMap.put("org.eclipse.jdt.core.compiler.problem.unusedLabel", "ignore");
        String compliance = FullSourceWorkspaceTests.compliance();
        if (compliance != null) {
            optionsMap.put("org.eclipse.jdt.core.compiler.compliance", compliance);
            optionsMap.put("org.eclipse.jdt.core.compiler.source", compliance);
            optionsMap.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compliance);
        }
        return optionsMap;
    }

    static {
        COMPLIANCE = System.getProperty("compliance");
        INDEX_MANAGER = JavaModelManager.getIndexManager();
    }

    static class FullSourceProjectsFilter
    implements FileFilter {
        FullSourceProjectsFilter() {
        }

        public boolean accept(File project) {
            StringTokenizer tokenizer;
            String token;
            if (project.isDirectory() && (token = (tokenizer = new StringTokenizer(project.getName(), ".")).nextToken()).equals("org") && tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.equals("junit") && !tokenizer.hasMoreTokens()) {
                    return true;
                }
                if (token.equals("apache")) {
                    token = tokenizer.nextToken();
                    return token.equals("ant") || token.equals("lucene");
                }
                if (token.equals("eclipse") && tokenizer.hasMoreTokens()) {
                    return true;
                }
            }
            return false;
        }
    }
}

