/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;
import org.eclipse.jdt.internal.core.search.processing.IJob;

public class FullSourceWorkspaceSearchTests
extends FullSourceWorkspaceTests
implements IJavaSearchConstants {
    private static final int WAIT_UNTIL_READY_TO_SEARCH = 0;

    public static void runDaCapoTests() {
        try {
            FullSourceWorkspaceSearchTests s = new FullSourceWorkspaceSearchTests();
            System.out.print("Index workspace ");
            s.testIndexing();
            System.out.println();
        }
        catch (Exception e) {
            System.err.println("Caught exception performing search tests: ");
            e.printStackTrace();
        }
    }

    public void testIndexing() throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        INDEX_MANAGER.removeIndexFamily((IPath)new Path(""));
        INDEX_MANAGER.reset();
        INDEX_MANAGER.request((IJob)new Measuring(true));
        int length = ALL_PROJECTS.length;
        for (int j = 0; j < length; ++j) {
            System.out.print(".");
            INDEX_MANAGER.indexAll(ALL_PROJECTS[j].getProject());
        }
        this.waitUntilIndexesReady();
    }

    protected void waitUntilIndexesReady() {
        System.out.print(".");
        AbstractJavaModelTests.waitUntilIndexesReady();
        System.out.print(".");
    }

    class Measuring
    implements IJob {
        boolean start;

        Measuring(boolean start) {
            this.start = start;
        }

        public boolean belongsTo(String jobFamily) {
            return true;
        }

        public void cancel() {
        }

        public void ensureReadyToRun() {
        }

        public boolean execute(IProgressMonitor progress) {
            return true;
        }

        public String getJobFamily() {
            return "FullSourceWorkspaceSearchTests.Measuring";
        }
    }

    class SearchTypeNameRequestor
    extends TypeNameRequestor {
        int count = 0;

        SearchTypeNameRequestor() {
        }

        public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            ++this.count;
            if (this.count % 500 == 0) {
                System.out.print(".");
            }
        }
    }
}

