/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;

public class FullSourceWorkspaceModelTests
extends FullSourceWorkspaceTests {
    public static void runDaCapoTests() {
        try {
            FullSourceWorkspaceModelTests m = new FullSourceWorkspaceModelTests();
            System.out.print("Model tests ");
            m.testFindType();
            System.out.println();
        }
        catch (Exception e) {
            System.err.println("Caught exception performing search tests: ");
            e.printStackTrace();
        }
    }

    private IJavaProject createJavaProject(String name) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists()) {
            project.delete(true, null);
        }
        project.create(null);
        project.open(null);
        IProjectDescription description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        project.setDescription(description, null);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setRawClasspath(new IClasspathEntry[]{JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), null, null)}, null);
        return javaProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindType() throws CoreException {
        int i;
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IJavaProject[] existingProjects = model.getJavaProjects();
        try {
            int i2;
            int length = existingProjects.length;
            for (i = 0; i < length; ++i) {
                existingProjects[i].getProject().close(null);
                if (i % 4 != 0) continue;
                System.out.print(".");
            }
            int max = 20;
            IJavaProject[] projects = new IJavaProject[max];
            for (i2 = 0; i2 < max; ++i2) {
                projects[i2] = this.createJavaProject("FindType" + i2);
                if (i2 % 4 != 0) continue;
                System.out.print(".");
            }
            AbstractJavaModelTests.waitUntilIndexesReady();
            System.out.print(".");
            AbstractJavaModelTests.waitForAutoBuild();
            try {
                model.close();
                for (int j = 0; j < max; ++j) {
                    projects[j].findType("java.lang.Object");
                    if (j % 4 != 0) continue;
                    System.out.print(".");
                }
            }
            finally {
                for (i2 = 0; i2 < max; ++i2) {
                    projects[i2].getProject().delete(false, null);
                }
            }
        }
        finally {
            int length = existingProjects.length;
            for (i = 0; i < length; ++i) {
                existingProjects[i].getProject().open(null);
            }
        }
    }
}

