/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;

public class FullSourceWorkspaceCompletionTests
extends FullSourceWorkspaceTests {
    private static final int WARMUP_COUNT = 0;
    private static final int ITERATION_COUNT = 10;
    static int[] PROPOSAL_COUNTS;
    static int TESTS_COUNT;
    static int TESTS_LENGTH;

    public static void runDaCapoTests() {
        try {
            FullSourceWorkspaceCompletionTests c = new FullSourceWorkspaceCompletionTests();
            System.out.print("Completion tests ");
            System.out.print(".");
            c.testPerfCompleteEmptyName();
            System.out.print(".");
            c.testPerfCompleteEmptyNameWithoutMethods();
            System.out.print(".");
            c.testPerfCompleteEmptyNameWithoutTypes();
            System.out.print(".");
            c.testPerfCompleteMemberAccess();
            System.out.print(".");
            c.testPerfCompleteMethodDeclaration();
            System.out.print(".");
            c.testPerfCompleteName();
            System.out.print(".");
            c.testPerfCompleteNameWithoutMethods();
            System.out.print(".");
            c.testPerfCompleteNameWithoutTypes();
            System.out.print(".");
            c.testPerfCompleteTypeReference();
            System.out.println();
        }
        catch (Exception e) {
            System.err.println("Caught exception performing build tests: ");
            e.printStackTrace();
        }
    }

    private void complete(String projectName, String packageName, String unitName, String completeAt, String completeBehind, int warmupCount, int iterationCount) throws CoreException {
        this.complete(projectName, packageName, unitName, completeAt, completeBehind, null, warmupCount, iterationCount);
    }

    private void complete(String projectName, String packageName, String unitName, String completeAt, String completeBehind, int[] ignoredKinds, int warmupCount, int iterationCount) throws CoreException {
        AbstractJavaModelTests.waitUntilIndexesReady();
        TestCompletionRequestor requestor = new TestCompletionRequestor();
        if (ignoredKinds != null) {
            for (int i = 0; i < ignoredKinds.length; ++i) {
                requestor.setIgnored(ignoredKinds[i], true);
            }
        }
        ICompilationUnit unit = this.getCompilationUnit(projectName, packageName, unitName);
        String str = unit.getSource();
        int completionIndex = str.indexOf(completeAt) + completeBehind.length();
        if (DEBUG) {
            System.out.print("Perform code assist inside " + unitName + "...");
        }
        for (int j = 0; j < iterationCount; ++j) {
            unit.codeComplete(completionIndex, (CompletionRequestor)requestor);
        }
        if (DEBUG) {
            System.out.println("done!");
        }
    }

    public void testPerfCompleteMethodDeclaration() throws CoreException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "IType {", "IType {", 0, 10);
    }

    public void testPerfCompleteMemberAccess() throws CoreException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "this.", "this.", null, 0, 10);
    }

    public void testPerfCompleteTypeReference() throws CoreException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "ArrayList list", "A", 0, 10);
    }

    public void testPerfCompleteEmptyName() throws CoreException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "", 0, 10);
    }

    public void testPerfCompleteName() throws CoreException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "p", null, 0, 10);
    }

    public void testPerfCompleteEmptyNameWithoutTypes() throws CoreException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "", new int[]{9}, 0, 10);
    }

    public void testPerfCompleteNameWithoutTypes() throws CoreException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "p", new int[]{9}, 0, 10);
    }

    public void testPerfCompleteEmptyNameWithoutMethods() throws CoreException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "", new int[]{6}, 0, 10);
    }

    public void testPerfCompleteNameWithoutMethods() throws CoreException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "p", new int[]{6}, 0, 10);
    }

    static {
        TESTS_COUNT = 0;
    }

    class TestCompletionRequestor
    extends CompletionRequestor {
        TestCompletionRequestor() {
        }

        public void accept(CompletionProposal proposal) {
        }
    }
}

