/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.text.NumberFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceSearchTests;

public class FullSourceWorkspaceCompleteSearchTests
extends FullSourceWorkspaceSearchTests {
    public static void runDaCapoTests() {
        try {
            FullSourceWorkspaceCompleteSearchTests s = new FullSourceWorkspaceCompleteSearchTests();
            System.out.print("Search ");
            s.testSearchStringConstructorReferences();
            System.out.println();
            System.out.print("       ");
            s.testSearchStringMethodReferences();
            System.out.println();
        }
        catch (Exception e) {
            System.err.println("Caught exception performing search tests: ");
            e.printStackTrace();
        }
    }

    protected void search(IJavaElement element, int limitTo, JavaSearchResultCollector resultCollector) throws CoreException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)element, (int)limitTo, (int)8);
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), (SearchRequestor)resultCollector, null);
    }

    protected void search(String patternString, int searchFor, int limitTo, JavaSearchResultCollector resultCollector) throws CoreException {
        int matchMode = patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1 ? 2 : 0;
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)(matchMode | 8));
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])ALL_PROJECTS, (int)1);
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)resultCollector, null);
    }

    protected void cleanCategoryTableCache(boolean type, JavaSearchResultCollector resultCollector) throws CoreException {
        long time = System.currentTimeMillis();
        if (type) {
            this.search("foo", 4, 0, resultCollector);
        } else {
            this.search("Foo", 0, 0, resultCollector);
        }
        if (DEBUG) {
            System.out.println("Time to clean category table cache: " + (System.currentTimeMillis() - time));
        }
    }

    public void testSearchStringConstructorReferences() throws CoreException {
        this.waitUntilIndexesReady();
        String name = "()";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search(name, 3, 2, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.print(" " + intFormat.format(resultCollector.count) + " references for default constructor in workspace");
    }

    public void testSearchStringMethodReferences() throws CoreException {
        this.waitUntilIndexesReady();
        String name = "equals";
        JavaSearchResultCollector resultCollector = new JavaSearchResultCollector();
        this.search(name, 1, 2, resultCollector);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        System.out.print(" " + intFormat.format(resultCollector.count) + " references for method '" + name + "' in workspace");
    }

    class JavaSearchResultCollector
    extends SearchRequestor {
        int count = 0;

        JavaSearchResultCollector() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            ++this.count;
        }
    }
}

