/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;

public class FullSourceWorkspaceBuildTests
extends FullSourceWorkspaceTests {
    public static void runDaCapoTests() {
        try {
            FullSourceWorkspaceBuildTests b = new FullSourceWorkspaceBuildTests();
            System.out.print("Build workspace ");
            b.testFullBuildDefault();
            System.out.println();
        }
        catch (Exception e) {
            System.err.println("Caught exception performing build tests: ");
            e.printStackTrace();
        }
    }

    void build(final IJavaProject javaProject, Hashtable options, boolean noWarning) throws IOException, CoreException {
        if (DEBUG) {
            System.out.print("\tstart build...");
        }
        JavaCore.setOptions((Hashtable)options);
        if (PRINT) {
            System.out.println("JavaCore options: " + options);
        }
        if (javaProject == null) {
            ENV.fullBuild();
        } else {
            if (PRINT) {
                System.out.println("Project options: " + javaProject.getOptions(false));
            }
            IWorkspaceRunnable compilation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    FullSourceWorkspaceTests.ENV.fullBuild(javaProject.getPath());
                }
            };
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.run(compilation, null, 1, null);
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IMarker[] markers = workspaceRoot.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        ArrayList<String> resources = new ArrayList<String>();
        ArrayList<Object> messages = new ArrayList<Object>();
        int warnings = 0;
        int length = markers.length;
        block4: for (int i = 0; i < length; ++i) {
            IMarker marker = markers[i];
            switch ((Integer)marker.getAttribute("severity")) {
                case 2: {
                    resources.add(marker.getResource().getName());
                    messages.add(marker.getAttribute("message"));
                    continue block4;
                }
                case 1: {
                    ++warnings;
                    if (!noWarning) continue block4;
                    resources.add(marker.getResource().getName());
                    messages.add(marker.getAttribute("message"));
                }
            }
        }
        workspaceRoot.deleteMarkers("org.eclipse.jdt.core.problem", true, 2);
        int size = messages.size();
        if (size > 0) {
            String target;
            StringBuffer debugBuffer = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                debugBuffer.append(resources.get(i));
                debugBuffer.append(":\n\t");
                debugBuffer.append(messages.get(i));
                debugBuffer.append('\n');
            }
            System.out.println("Unexpected ERROR marker(s):\n" + debugBuffer.toString());
            System.out.println("--------------------");
            String string = target = javaProject == null ? "workspace" : javaProject.getElementName();
        }
        if (DEBUG) {
            System.out.println("done");
        }
    }

    public void testFullBuildDefault() throws CoreException, IOException {
        this.build(null, this.warningOptions(0), false);
    }
}

