/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;

public class FullSourceWorkspaceASTTests
extends FullSourceWorkspaceTests {
    public static void runDaCapoTests() {
        try {
            FullSourceWorkspaceASTTests a = new FullSourceWorkspaceASTTests();
            System.out.print("AST tests ");
            a.testDomAstCreationProjectJLS3();
            System.out.println();
        }
        catch (Exception e) {
            System.err.println("Caught exception performing AST tests: ");
            e.printStackTrace();
        }
    }

    private void runAstCreation(IJavaProject javaProject) throws Exception {
        if (DEBUG) {
            System.out.println("Creating AST for project" + javaProject.getElementName());
        }
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setProject(javaProject);
        Map options = javaProject.getOptions(true);
        Iterator iter = options.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)options.get(key);
            if ("error".equals(value) || "warning".equals(value)) {
                options.put(key, "ignore");
                continue;
            }
            if (!"enabled".equals(value)) continue;
            options.put(key, "disabled");
        }
        options.put("org.eclipse.jdt.core.compiler.taskTags", "");
        parser.setCompilerOptions(options);
        List units = this.getProjectCompilationUnits(javaProject);
        ICompilationUnit[] compilationUnits = new ICompilationUnit[units.size()];
        units.toArray(compilationUnits);
        if (PRINT) {
            System.out.println("            - options: " + options);
            System.out.println("            - " + compilationUnits.length + " units will be parsed in " + javaProject.getElementName() + " project");
        }
        parser.createASTs(compilationUnits, new String[0], new ASTRequestor(){

            public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
                IProblem[] problems = ast.getProblems();
                int length = problems.length;
                if (length > 0) {
                    StringBuffer buffer = new StringBuffer();
                    for (int i = 0; i < length; ++i) {
                        buffer.append(problems[i].getMessage());
                        buffer.append('\n');
                    }
                }
            }
        }, null);
        parser.createASTs(compilationUnits, new String[0], new ASTRequestor(){}, null);
    }

    public void testDomAstCreationProjectJLS3() throws Exception {
        this.runAstCreation(this.getProject("org.eclipse.core.runtime"));
    }
}

