/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;

public class TestingEnvironment {
    private boolean isOpen = false;
    private IWorkspace workspace = null;
    private Hashtable projects = null;

    public void openEmptyWorkspace() {
        this.close();
        this.openWorkspace();
        this.projects = new Hashtable(10);
        this.setup();
    }

    private void openWorkspace() {
        try {
            this.closeWorkspace();
            this.workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = this.workspace.getDescription();
            description.setAutoBuilding(false);
            this.workspace.setDescription(description);
        }
        catch (Exception e) {
            this.handle(e);
        }
    }

    private void checkAssertion(String message, boolean b) {
        Assert.isTrue((boolean)b, (String)message);
    }

    public void close() {
        try {
            if (this.projects != null) {
                Enumeration projectNames = this.projects.keys();
                while (projectNames.hasMoreElements()) {
                    String projectName = (String)projectNames.nextElement();
                    this.getJavaProject(projectName).getJavaModel().close();
                }
            }
            this.closeWorkspace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void closeProject(IPath projectPath) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getJavaProject(projectPath).getProject().close(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void closeWorkspace() {
        this.isOpen = false;
    }

    private void setup() {
        this.isOpen = true;
    }

    void handle(Exception e) {
        if (e instanceof CoreException) {
            this.handleCoreException((CoreException)((Object)e));
        } else {
            e.printStackTrace();
            Assert.isTrue((boolean)false);
        }
    }

    private void handleCoreException(CoreException e) {
        e.printStackTrace();
        IStatus status = e.getStatus();
        String message = e.getMessage();
        if (status.isMultiStatus()) {
            MultiStatus multiStatus = (MultiStatus)status;
            IStatus[] children = multiStatus.getChildren();
            StringBuffer buffer = new StringBuffer();
            int max = children.length;
            for (int i = 0; i < max; ++i) {
                IStatus child = children[i];
                if (child == null) continue;
                buffer.append(child.getMessage());
                buffer.append(System.getProperty("line.separator"));
                Throwable childException = child.getException();
                if (childException == null) continue;
                childException.printStackTrace();
            }
            message = buffer.toString();
        }
        Assert.isTrue((boolean)false, (String)("Core exception in testing environment: " + message));
    }

    public IJavaProject getJavaProject(IPath projectPath) {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject(projectPath));
        Assert.isNotNull((Object)javaProject);
        return javaProject;
    }

    public IJavaProject getJavaProject(String projectName) {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject(projectName));
        Assert.isNotNull((Object)javaProject);
        return javaProject;
    }

    public IProject getProject(String projectName) {
        return (IProject)this.projects.get(projectName);
    }

    private IProject createProject(String projectName) {
        final IProject project = this.workspace.getRoot().getProject(projectName);
        try {
            IWorkspaceRunnable create = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    project.create(null, null);
                    project.open(null);
                }
            };
            this.workspace.run(create, null);
            this.projects.put(projectName, project);
            this.addBuilderSpecs(projectName);
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
        return project;
    }

    private void addBuilderSpecs(String projectName) {
        try {
            IProject project = this.getProject(projectName);
            IProjectDescription description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public IProject getProject(IPath projectPath) {
        return (IProject)this.projects.get(projectPath.lastSegment());
    }

    public void addProject(IProject project) {
        this.projects.put(project.getName(), project);
    }

    public IPath addProject(String projectName) {
        return this.addProject(projectName, "1.4");
    }

    public IPath addProject(String projectName, String compliance) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        IProject project = this.createProject(projectName);
        int requiredComplianceFlag = 0;
        String compilerVersion = null;
        if ("1.5".equals(compliance)) {
            requiredComplianceFlag = 4;
            compilerVersion = "1.5";
        } else if ("1.6".equals(compliance)) {
            requiredComplianceFlag = 8;
            compilerVersion = "1.6";
        } else if ("1.7".equals(compliance)) {
            requiredComplianceFlag = 16;
            compilerVersion = "1.7";
        } else if (!"1.4".equals(compliance) && !"1.3".equals(compliance)) {
            throw new UnsupportedOperationException("Test framework doesn't support compliance level: " + compliance);
        }
        if (requiredComplianceFlag != 0) {
            if ((AbstractCompilerTest.getPossibleComplianceLevels() & requiredComplianceFlag) == 0) {
                throw new RuntimeException("This test requires a " + compliance + " JRE");
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("org.eclipse.jdt.core.compiler.compliance", compilerVersion);
            options.put("org.eclipse.jdt.core.compiler.source", compilerVersion);
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compilerVersion);
            javaProject.setOptions(options);
        }
        return project.getFullPath();
    }

    public void fullBuild() {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getWorkspace().build(6, null);
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
    }

    public void fullBuild(IPath projectPath) {
        this.fullBuild(projectPath.lastSegment());
    }

    public void fullBuild(String projectName) {
        this.checkAssertion("a workspace must be open", this.isOpen);
        try {
            this.getProject(projectName).build(6, null);
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }
}

